/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test.client;

import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.test.client.AbstractTestClient;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ExecutionConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ProjectConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.TestConfig;
import de.tracetronic.jenkins.plugins.ecutest.util.DllUtil;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComClient;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComException;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComProperty;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.Project;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.TestEnvironment;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.TestExecutionInfo;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.File;
import java.io.IOException;
import jenkins.security.MasterToSlaveCallable;

public class ProjectClient
extends AbstractTestClient {
    private final ProjectConfig projectConfig;

    public ProjectClient(String testFile, TestConfig testConfig, ProjectConfig projectConfig, ExecutionConfig executionConfig) {
        super(testFile, testConfig, executionConfig);
        this.projectConfig = projectConfig;
    }

    public ProjectConfig getProjectConfig() {
        return this.projectConfig;
    }

    @Override
    public boolean runTestCase(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        if (!DllUtil.loadLibrary(workspace.toComputer())) {
            logger.logError("Could not load JACOB library!");
            return false;
        }
        if (!this.getTestConfig().isKeepConfig() && !((Boolean)launcher.getChannel().call((Callable)new AbstractTestClient.LoadConfigCallable(this.getTestConfig(), listener))).booleanValue()) {
            return false;
        }
        AbstractTestClient.TestInfoHolder prjInfo = (AbstractTestClient.TestInfoHolder)launcher.getChannel().call((Callable)new OpenProjectCallable(this.getTestFile(), this.getProjectConfig(), this.getExecutionConfig(), listener));
        if (prjInfo != null) {
            this.setTestName(prjInfo.getTestName());
            this.setTestDescription(prjInfo.getTestDescription());
            if (this.getExecutionConfig().isRecordWarnings() && this.recordWarnings(prjInfo, run, workspace, launcher, listener)) {
                return false;
            }
        } else {
            return false;
        }
        try {
            AbstractTestClient.ExecutionInfoHolder testInfo = (AbstractTestClient.ExecutionInfoHolder)launcher.getChannel().call((Callable)new RunProjectCallable(this.getTestFile(), this.getProjectConfig(), this.getExecutionConfig(), listener));
            if (testInfo == null) {
                return false;
            }
            this.setTestResult(testInfo.getTestResult());
            this.setTestReportDir(testInfo.getTestReportDir());
            this.setAborted(testInfo.isAborted());
        }
        catch (InterruptedException e) {
            logger.logError("Test execution has been interrupted!");
            return false;
        }
        return (Boolean)launcher.getChannel().call((Callable)new CloseProjectCallable(this.getTestFile(), listener));
    }

    private static final class CloseProjectCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final String projectFile;
        private final TaskListener listener;

        CloseProjectCallable(String projectFile, TaskListener listener) {
            this.projectFile = projectFile;
            this.listener = listener;
        }

        public Boolean call() throws IOException {
            boolean isClosed = false;
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            logger.logInfo("- Closing project...");
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);){
                if (comClient.closeProject(this.projectFile)) {
                    isClosed = true;
                    logger.logInfo("-> Project closed successfully.");
                } else {
                    logger.logError("-> Closing project failed!");
                }
            }
            catch (ETComException e) {
                logger.logComException(e);
            }
            return isClosed;
        }
    }

    private static final class RunProjectCallable
    extends MasterToSlaveCallable<AbstractTestClient.ExecutionInfoHolder, IOException> {
        private static final long serialVersionUID = 1L;
        private final String projectFile;
        private final ProjectConfig projectConfig;
        private final ExecutionConfig executionConfig;
        private final TaskListener listener;

        RunProjectCallable(String projectFile, ProjectConfig projectConfig, ExecutionConfig executionConfig, TaskListener listener) {
            this.projectFile = projectFile;
            this.projectConfig = projectConfig;
            this.executionConfig = executionConfig;
            this.listener = listener;
        }

        public AbstractTestClient.ExecutionInfoHolder call() throws IOException {
            int jobExecutionMode = this.projectConfig.getJobExecMode().getValue();
            int timeout = this.executionConfig.getParsedTimeout();
            AbstractTestClient.ExecutionInfoHolder testInfo = null;
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            logger.logInfo("- Running project...");
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);
                 TestEnvironment testEnv = (TestEnvironment)comClient.getTestEnvironment();
                 TestExecutionInfo execInfo = (TestExecutionInfo)testEnv.executeProject(this.projectFile, true, jobExecutionMode);){
                boolean isAborted = false;
                int tickCounter = 0;
                long endTimeMillis = System.currentTimeMillis() + (long)timeout * 1000L;
                while ("RUNNING".equals(execInfo.getState())) {
                    if (tickCounter % 60 == 0) {
                        logger.logInfo("-- tick...");
                    }
                    if (timeout > 0 && System.currentTimeMillis() > endTimeMillis) {
                        logger.logWarn(String.format("-> Test execution timeout of %d seconds reached! Aborting project now...", timeout));
                        isAborted = true;
                        execInfo.abort();
                        break;
                    }
                    Thread.sleep(1000L);
                    ++tickCounter;
                }
                testInfo = this.getTestInfo(execInfo, isAborted, logger);
                this.postExecution(timeout, comClient, logger);
            }
            catch (ETComException e) {
                logger.logComException(e);
            }
            catch (InterruptedException e) {
                testInfo = this.abortTestExecution(timeout, progId, logger);
            }
            return testInfo;
        }

        private AbstractTestClient.ExecutionInfoHolder abortTestExecution(int timeout, String progId, TTConsoleLogger logger) {
            AbstractTestClient.ExecutionInfoHolder testInfo = null;
            try (ETComClient comClient = new ETComClient(progId);
                 TestEnvironment testEnv = (TestEnvironment)comClient.getTestEnvironment();
                 TestExecutionInfo execInfo = (TestExecutionInfo)testEnv.getTestExecutionInfo();){
                logger.logWarn("-> Build interrupted! Aborting test exection...");
                execInfo.abort();
                testInfo = this.getTestInfo(execInfo, true, logger);
                this.postExecution(timeout, comClient, logger);
            }
            catch (ETComException e) {
                logger.logComException(e);
            }
            return testInfo;
        }

        private AbstractTestClient.ExecutionInfoHolder getTestInfo(TestExecutionInfo execInfo, boolean isAborted, TTConsoleLogger logger) throws ETComException {
            String testResult = execInfo.getResult();
            logger.logInfo(String.format("-> Project execution %s with result: %s", isAborted ? "aborted" : "completed", testResult));
            String testReportDir = new File(execInfo.getReportDb()).getParentFile().getAbsolutePath();
            logger.logInfo(String.format("-> Test report directory: %s", testReportDir));
            return new AbstractTestClient.ExecutionInfoHolder(testResult, testReportDir, isAborted);
        }

        private void postExecution(int timeout, ETComClient comClient, TTConsoleLogger logger) throws ETComException {
            if (!comClient.waitForIdle(timeout)) {
                logger.logWarn(String.format("-> Post-execution timeout of %d seconds reached!", timeout));
            }
        }
    }

    private static final class OpenProjectCallable
    extends AbstractTestClient.OpenTestFileCallable {
        private static final long serialVersionUID = 1L;

        OpenProjectCallable(String projectFile, ProjectConfig projectConfig, ExecutionConfig executionConfig, TaskListener listener) {
            super(projectFile, projectConfig, executionConfig, listener);
        }

        @Override
        public AbstractTestClient.TestInfoHolder call() throws IOException {
            AbstractTestClient.TestInfoHolder testInfo = null;
            TTConsoleLogger logger = new TTConsoleLogger(this.getListener());
            logger.logInfo("- Opening project...");
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);
                 Project prj = (Project)comClient.openProject(this.getTestFile(), ((ProjectConfig)this.getTestFileConfig()).isExecInCurrentPkgDir(), ((ProjectConfig)this.getTestFileConfig()).getFilterExpression());){
                logger.logInfo("-> Project opened successfully.");
                testInfo = this.checkTestFile(prj, comClient, logger);
            }
            catch (ETComException e) {
                logger.logComException("-> Opening project failed", e);
            }
            return testInfo;
        }
    }
}

