/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test.client;

import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.test.client.AbstractTestClient;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ExecutionConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.PackageConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.PackageOutputParameter;
import de.tracetronic.jenkins.plugins.ecutest.test.config.PackageParameter;
import de.tracetronic.jenkins.plugins.ecutest.test.config.TestConfig;
import de.tracetronic.jenkins.plugins.ecutest.util.DllUtil;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComClient;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComException;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComProperty;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.Package;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.TestEnvironment;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.TestExecutionInfo;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import jenkins.security.MasterToSlaveCallable;

public class PackageClient
extends AbstractTestClient {
    private final PackageConfig packageConfig;
    private Map<String, String> outputParameters;

    public PackageClient(String testFile, TestConfig testConfig, PackageConfig packageConfig, ExecutionConfig executionConfig) {
        super(testFile, testConfig, executionConfig);
        this.packageConfig = packageConfig;
    }

    public PackageConfig getPackageConfig() {
        return this.packageConfig;
    }

    public Map<String, String> getOutputParameters() {
        return this.outputParameters;
    }

    public void setOutputParameters(Map<String, String> outParams) {
        this.outputParameters = outParams;
    }

    @Override
    public boolean runTestCase(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        if (!DllUtil.loadLibrary(workspace.toComputer())) {
            logger.logError("Could not load JACOB library!");
            return false;
        }
        if (!this.getTestConfig().isKeepConfig() && !((Boolean)launcher.getChannel().call((Callable)new AbstractTestClient.LoadConfigCallable(this.getTestConfig(), listener))).booleanValue()) {
            return false;
        }
        AbstractTestClient.TestInfoHolder pkgInfo = (AbstractTestClient.TestInfoHolder)launcher.getChannel().call((Callable)new OpenPackageCallable(this.getTestFile(), this.getPackageConfig(), this.getExecutionConfig(), listener));
        if (pkgInfo != null) {
            this.setTestName(pkgInfo.getTestName());
            this.setTestDescription(pkgInfo.getTestDescription());
            if (this.getExecutionConfig().isRecordWarnings() && this.recordWarnings(pkgInfo, run, workspace, launcher, listener)) {
                return false;
            }
        } else {
            return false;
        }
        try {
            PackageExecutioInfoHolder testInfo = (PackageExecutioInfoHolder)launcher.getChannel().call((Callable)new RunPackageCallable(this.getTestFile(), this.getPackageConfig(), this.getExecutionConfig(), listener));
            if (testInfo == null) {
                return false;
            }
            this.setTestResult(testInfo.getTestResult());
            this.setTestReportDir(testInfo.getTestReportDir());
            this.setAborted(testInfo.isAborted());
            this.setOutputParameters(testInfo.getOutputParameters());
        }
        catch (InterruptedException e) {
            logger.logError("Test execution has been interrupted!");
            return false;
        }
        return (Boolean)launcher.getChannel().call((Callable)new ClosePackageCallable(this.getTestFile(), listener));
    }

    protected static final class PackageExecutioInfoHolder
    extends AbstractTestClient.ExecutionInfoHolder
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<String, String> outputParameters;

        public PackageExecutioInfoHolder(String testResult, String testReportDir, boolean isAborted, Map<String, String> outputParameters) {
            super(testResult, testReportDir, isAborted);
            this.outputParameters = outputParameters;
        }

        public Map<String, String> getOutputParameters() {
            return this.outputParameters;
        }
    }

    private static final class ClosePackageCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final String packageFile;
        private final TaskListener listener;

        ClosePackageCallable(String packageFile, TaskListener listener) {
            this.packageFile = packageFile;
            this.listener = listener;
        }

        public Boolean call() throws IOException {
            boolean isClosed = false;
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            logger.logInfo("- Closing package...");
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);){
                if (comClient.closePackage(this.packageFile)) {
                    isClosed = true;
                    logger.logInfo("-> Package closed successfully.");
                } else {
                    logger.logError("-> Closing package failed!");
                }
            }
            catch (ETComException e) {
                logger.logComException(e);
            }
            return isClosed;
        }
    }

    private static final class RunPackageCallable
    extends MasterToSlaveCallable<PackageExecutioInfoHolder, IOException> {
        private static final long serialVersionUID = 1L;
        private final String packageFile;
        private final PackageConfig packageConfig;
        private final ExecutionConfig executionConfig;
        private final TaskListener listener;

        RunPackageCallable(String packageFile, PackageConfig packageConfig, ExecutionConfig executionConfig, TaskListener listener) {
            this.packageFile = packageFile;
            this.packageConfig = packageConfig;
            this.executionConfig = executionConfig;
            this.listener = listener;
        }

        public PackageExecutioInfoHolder call() throws IOException {
            List<String> outParamList;
            boolean runTest = this.packageConfig.isRunTest();
            boolean runTraceAnalysis = this.packageConfig.isRunTraceAnalysis();
            int timeout = this.executionConfig.getParsedTimeout();
            PackageExecutioInfoHolder testInfo = null;
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            logger.logInfo("- Running package...");
            Map<String, String> paramMap = this.getParameterMap();
            if (!paramMap.isEmpty()) {
                logger.logInfo("-> With parameters: " + paramMap.toString());
            }
            if (!(outParamList = this.packageConfig.getOutputParameters().stream().map(PackageOutputParameter::getName).collect(Collectors.toList())).isEmpty()) {
                logger.logInfo("-> With output parameters: " + outParamList.toString());
            }
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);
                 TestEnvironment testEnv = (TestEnvironment)comClient.getTestEnvironment();
                 TestExecutionInfo execInfo = (TestExecutionInfo)testEnv.executePackage(this.packageFile, runTraceAnalysis, runTest, paramMap);){
                boolean isAborted = false;
                int tickCounter = 0;
                long endTimeMillis = System.currentTimeMillis() + (long)timeout * 1000L;
                while ("RUNNING".equals(execInfo.getState())) {
                    if (tickCounter % 60 == 0) {
                        logger.logInfo("-- tick...");
                    }
                    if (timeout > 0 && System.currentTimeMillis() > endTimeMillis) {
                        logger.logWarn(String.format("-> Test execution timeout of %d seconds reached! Aborting package now...", timeout));
                        isAborted = true;
                        execInfo.abort();
                        break;
                    }
                    Thread.sleep(1000L);
                    ++tickCounter;
                }
                testInfo = this.getExecutionInfo(execInfo, isAborted, logger, outParamList);
                this.postExecution(timeout, comClient, logger);
            }
            catch (ETComException e) {
                logger.logComException(e);
            }
            catch (InterruptedException e) {
                testInfo = this.abortTestExecution(timeout, progId, logger, outParamList);
            }
            return testInfo;
        }

        private Map<String, String> getParameterMap() {
            LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
            for (PackageParameter param : this.packageConfig.getParameters()) {
                paramMap.put(param.getName(), param.getValue());
            }
            return paramMap;
        }

        private PackageExecutioInfoHolder getExecutionInfo(TestExecutionInfo execInfo, boolean isAborted, TTConsoleLogger logger, List<String> outParamList) throws ETComException {
            String testResult = execInfo.getResult();
            logger.logInfo(String.format("-> Package execution %s with result: %s", isAborted ? "aborted" : "completed", testResult));
            String testReportDir = new File(execInfo.getReportDb()).getParentFile().getAbsolutePath();
            logger.logInfo(String.format("-> Test report directory: %s", testReportDir));
            Map<String, String> outParamMap = outParamList.stream().collect(Collectors.toMap(e -> e.toUpperCase(Locale.getDefault()), e -> {
                try {
                    return execInfo.getReturnValue((String)e);
                }
                catch (ETComException exception) {
                    logger.logComException(exception);
                    return "";
                }
            }));
            return new PackageExecutioInfoHolder(testResult, testReportDir, isAborted, outParamMap);
        }

        private PackageExecutioInfoHolder abortTestExecution(int timeout, String progId, TTConsoleLogger logger, List<String> outParamList) {
            PackageExecutioInfoHolder testInfo = null;
            try (ETComClient comClient = new ETComClient(progId);
                 TestEnvironment testEnv = (TestEnvironment)comClient.getTestEnvironment();
                 TestExecutionInfo execInfo = (TestExecutionInfo)testEnv.getTestExecutionInfo();){
                logger.logWarn("-> Build interrupted! Aborting test exection...");
                execInfo.abort();
                testInfo = this.getExecutionInfo(execInfo, true, logger, outParamList);
                this.postExecution(timeout, comClient, logger);
            }
            catch (ETComException e) {
                logger.logComException(e);
            }
            return testInfo;
        }

        private void postExecution(int timeout, ETComClient comClient, TTConsoleLogger logger) throws ETComException {
            if (!comClient.waitForIdle(timeout)) {
                logger.logWarn(String.format("-> Post-execution timeout of %d seconds reached!", timeout));
            }
        }
    }

    private static final class OpenPackageCallable
    extends AbstractTestClient.OpenTestFileCallable {
        private static final long serialVersionUID = 1L;

        OpenPackageCallable(String packageFile, PackageConfig packageConfig, ExecutionConfig executionConfig, TaskListener listener) {
            super(packageFile, packageConfig, executionConfig, listener);
        }

        @Override
        public AbstractTestClient.TestInfoHolder call() throws IOException {
            AbstractTestClient.TestInfoHolder testInfo = null;
            TTConsoleLogger logger = new TTConsoleLogger(this.getListener());
            logger.logInfo("- Opening package...");
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);
                 Package pkg = (Package)comClient.openPackage(this.getTestFile());){
                logger.logInfo("-> Package opened successfully.");
                testInfo = this.checkTestFile(pkg, comClient, logger);
            }
            catch (ETComException e) {
                logger.logComException("-> Opening package failed", e);
            }
            return testInfo;
        }
    }
}

