/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test.client;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.test.client.AbstractTMSClient;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportPackageAttributeConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportPackageConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportPackageDirConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.TMSConfig;
import de.tracetronic.jenkins.plugins.ecutest.util.ToolVersion;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComClient;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComException;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComProperty;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.TestManagement;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.IOException;
import jenkins.security.MasterToSlaveCallable;

public class ImportPackageClient
extends AbstractTMSClient {
    private static final ToolVersion ET_MIN_VERSION = new ToolVersion(6, 6, 0);
    private final TMSConfig importConfig;

    public ImportPackageClient(TMSConfig importConfig) {
        this.importConfig = importConfig;
    }

    public TMSConfig getImportConfig() {
        return this.importConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean importPackage(Item project, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        boolean isImported = false;
        if (this.isCompatible(ET_MIN_VERSION, workspace, launcher, listener)) {
            try {
                StandardUsernamePasswordCredentials credentials = this.importConfig.getCredentials(project);
                if (this.login(credentials, launcher, listener)) {
                    if (this.importConfig instanceof ImportPackageDirConfig) {
                        isImported = this.importPackageDirFromTMS(launcher, listener);
                    } else if (this.importConfig instanceof ImportPackageConfig) {
                        isImported = this.importPackageFromTMS(launcher, listener);
                    }
                }
            }
            finally {
                this.logout(launcher, listener);
            }
        }
        return isImported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean importPackageAttributes(Item project, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        boolean isImported = false;
        if (this.isCompatible(ET_MIN_VERSION, workspace, launcher, listener)) {
            try {
                StandardUsernamePasswordCredentials credentials = this.importConfig.getCredentials(project);
                if (this.login(credentials, launcher, listener)) {
                    isImported = this.importPackageAttributesFromTMS(launcher, listener);
                }
            }
            finally {
                this.logout(launcher, listener);
            }
        }
        return isImported;
    }

    private boolean importPackageFromTMS(Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return (Boolean)launcher.getChannel().call((Callable)new ImportPackageCallable((ImportPackageConfig)this.importConfig, listener));
    }

    private boolean importPackageDirFromTMS(Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return (Boolean)launcher.getChannel().call((Callable)new ImportPackageDirCallable((ImportPackageDirConfig)this.importConfig, listener));
    }

    private boolean importPackageAttributesFromTMS(Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return (Boolean)launcher.getChannel().call((Callable)new ImportPackageAttributeCallable((ImportPackageAttributeConfig)this.importConfig, listener));
    }

    private static final class ImportPackageAttributeCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final ImportPackageAttributeConfig importConfig;
        private final TaskListener listener;

        ImportPackageAttributeCallable(ImportPackageAttributeConfig importConfig, TaskListener listener) {
            this.importConfig = importConfig;
            this.listener = listener;
        }

        public Boolean call() throws IOException {
            boolean isImported = false;
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            logger.logInfo(String.format("- Importing attributes of package %s from test management system...", this.importConfig.getFilePath()));
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);){
                TestManagement tm = (TestManagement)comClient.getTestManagement();
                isImported = tm.importPackageAttributes(this.importConfig.getFilePath(), this.importConfig.getParsedTimeout());
                if (isImported) {
                    logger.logInfo("-> Package attributes imported successfully.");
                }
            }
            catch (ETComException e) {
                logger.logComException("-> Importing package attributes failed", e);
            }
            return isImported;
        }
    }

    private static final class ImportPackageDirCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final ImportPackageDirConfig importConfig;
        private final TaskListener listener;

        ImportPackageDirCallable(ImportPackageDirConfig importConfig, TaskListener listener) {
            this.importConfig = importConfig;
            this.listener = listener;
        }

        public Boolean call() throws IOException {
            boolean isImported = false;
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            logger.logInfo(String.format("- Importing package directory %s from test management system...", this.importConfig.getTmsPath()));
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);){
                TestManagement tm = (TestManagement)comClient.getTestManagement();
                isImported = tm.importPackageDirectory(this.importConfig.getTmsPath(), this.importConfig.getImportPath(), this.importConfig.getParsedTimeout());
                if (isImported) {
                    logger.logInfo(String.format("-> Package directory imported successfully to target directory %s.", this.importConfig.getImportPath()));
                }
            }
            catch (ETComException e) {
                logger.logComException("-> Importing package directory failed", e);
            }
            return isImported;
        }
    }

    private static final class ImportPackageCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final ImportPackageConfig importConfig;
        private final TaskListener listener;

        ImportPackageCallable(ImportPackageConfig importConfig, TaskListener listener) {
            this.importConfig = importConfig;
            this.listener = listener;
        }

        public Boolean call() throws IOException {
            boolean isImported = false;
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            logger.logInfo(String.format("- Importing package %s from test management system...", this.importConfig.getTmsPath()));
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);){
                TestManagement tm = (TestManagement)comClient.getTestManagement();
                isImported = tm.importPackage(this.importConfig.getTmsPath(), this.importConfig.getImportPath(), this.importConfig.getParsedTimeout());
                if (isImported) {
                    logger.logInfo(String.format("-> Package imported successfully to target directory %s.", this.importConfig.getImportPath()));
                }
            }
            catch (ETComException e) {
                logger.logComException("-> Importing package failed", e);
            }
            return isImported;
        }
    }
}

