/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test.client;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.test.client.AbstractTMSClient;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ExportProjectAttributeConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ExportProjectConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.TMSConfig;
import de.tracetronic.jenkins.plugins.ecutest.util.ToolVersion;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComClient;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComException;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComProperty;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.TestManagement;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.IOException;
import jenkins.security.MasterToSlaveCallable;

public class ExportProjectClient
extends AbstractTMSClient {
    private static final ToolVersion ET_MIN_VERSION = new ToolVersion(6, 5, 0);
    private static final ToolVersion ET_MIN_ATTR_VERSION = new ToolVersion(6, 6, 0);
    private final TMSConfig exportConfig;

    public ExportProjectClient(TMSConfig exportConfig) {
        this.exportConfig = exportConfig;
    }

    public TMSConfig getExportConfig() {
        return this.exportConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exportProject(Item project, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        boolean isExported = false;
        if (this.isCompatible(ET_MIN_VERSION, workspace, launcher, listener)) {
            try {
                StandardUsernamePasswordCredentials credentials = this.exportConfig.getCredentials(project);
                if (this.login(credentials, launcher, listener)) {
                    isExported = this.exportProjectToTMS(launcher, listener);
                }
            }
            finally {
                this.logout(launcher, listener);
            }
        }
        return isExported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exportProjectAttributes(Item project, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        boolean isExported = false;
        if (this.isCompatible(ET_MIN_ATTR_VERSION, workspace, launcher, listener)) {
            try {
                StandardUsernamePasswordCredentials credentials = this.exportConfig.getCredentials(project);
                if (this.login(credentials, launcher, listener)) {
                    isExported = this.exportProjectAttributesToTMS(launcher, listener);
                }
            }
            finally {
                this.logout(launcher, listener);
            }
        }
        return isExported;
    }

    private boolean exportProjectToTMS(Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return (Boolean)launcher.getChannel().call((Callable)new ExportProjectCallable((ExportProjectConfig)this.exportConfig, listener));
    }

    private boolean exportProjectAttributesToTMS(Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return (Boolean)launcher.getChannel().call((Callable)new ExportProjectAttributeCallable((ExportProjectAttributeConfig)this.exportConfig, listener));
    }

    private static final class ExportProjectAttributeCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final ExportProjectAttributeConfig exportConfig;
        private final TaskListener listener;

        ExportProjectAttributeCallable(ExportProjectAttributeConfig exportConfig, TaskListener listener) {
            this.exportConfig = exportConfig;
            this.listener = listener;
        }

        public Boolean call() throws IOException {
            boolean isExported = false;
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            logger.logInfo(String.format("- Exporting attributes of project %s to test management system...", this.exportConfig.getFilePath()));
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);){
                TestManagement tm = (TestManagement)comClient.getTestManagement();
                isExported = tm.exportProjectAttributes(this.exportConfig.getFilePath(), this.exportConfig.getParsedTimeout());
                if (isExported) {
                    logger.logInfo("-> Project attributes exported successfully.");
                }
            }
            catch (ETComException e) {
                logger.logComException("-> Exporting project attributes failed", e);
            }
            return isExported;
        }
    }

    private static final class ExportProjectCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final ExportProjectConfig exportConfig;
        private final TaskListener listener;

        ExportProjectCallable(ExportProjectConfig exportConfig, TaskListener listener) {
            this.exportConfig = exportConfig;
            this.listener = listener;
        }

        public Boolean call() throws IOException {
            boolean isExported = false;
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            logger.logInfo(String.format("- Exporting project %s to test management system...", this.exportConfig.getFilePath()));
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);){
                TestManagement tm = (TestManagement)comClient.getTestManagement();
                isExported = tm.exportProject(this.exportConfig.getFilePath(), this.exportConfig.getExportPath(), this.exportConfig.isCreateNewPath(), this.exportConfig.getParsedTimeout());
                if (isExported) {
                    logger.logInfo(String.format("-> Project exported successfully to target directory %s.", this.exportConfig.getExportPath()));
                }
            }
            catch (ETComException e) {
                logger.logComException("-> Exporting project failed", e);
            }
            return isExported;
        }
    }
}

