/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test.client;

import de.tracetronic.jenkins.plugins.ecutest.extension.warnings.WarningsRecorder;
import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.test.client.TestClient;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ExecutionConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ExpandableConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.GlobalConstant;
import de.tracetronic.jenkins.plugins.ecutest.test.config.TestConfig;
import de.tracetronic.jenkins.plugins.ecutest.util.ToolVersion;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.AbstractTestObject;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComClient;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComException;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComProperty;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.Package;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.TestConfiguration;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Plugin;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractTestClient
implements TestClient {
    private final String testFile;
    private final TestConfig testConfig;
    private final ExecutionConfig executionConfig;
    private String testName;
    private String testDescription;
    private String testReportDir;
    private String testResult;
    private boolean isAborted;

    public AbstractTestClient(String testFile, TestConfig testConfig, ExecutionConfig executionConfig) {
        this.testFile = StringUtils.trimToEmpty((String)testFile);
        this.testConfig = testConfig;
        this.executionConfig = executionConfig;
        this.testName = "";
        this.testDescription = "";
        this.testReportDir = "";
        this.testResult = "";
        this.isAborted = false;
    }

    public String getTestFile() {
        return this.testFile;
    }

    public TestConfig getTestConfig() {
        return this.testConfig;
    }

    public ExecutionConfig getExecutionConfig() {
        return this.executionConfig;
    }

    public String getTestName() {
        return this.testName;
    }

    public void setTestName(String testName) {
        this.testName = testName;
    }

    public String getTestDescription() {
        return this.testDescription;
    }

    public void setTestDescription(String testDescription) {
        this.testDescription = testDescription;
    }

    public String getTestReportDir() {
        return this.testReportDir;
    }

    public void setTestReportDir(String testReportDir) {
        this.testReportDir = testReportDir;
    }

    public String getTestResult() {
        return this.testResult;
    }

    public void setTestResult(String testResult) {
        this.testResult = testResult;
    }

    public boolean isAborted() {
        return this.isAborted;
    }

    public void setAborted(boolean isAborted) {
        this.isAborted = isAborted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean recordWarnings(TestInfoHolder testInfo, Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        Plugin plugin = Jenkins.getInstance().getPlugin("warnings-ng");
        if (plugin == null || !plugin.getWrapper().isActive()) {
            TTConsoleLogger logger = new TTConsoleLogger(listener);
            logger.logError("Warnings NG plugin not found or disabled, please install using the Update Center!");
            return true;
        }
        boolean hasIssues = false;
        if (StringUtils.isNotBlank((String)testInfo.warningsIssues)) {
            String issueFileName = "issues.json";
            FilePath issuesFile = workspace.child("issues.json");
            try {
                issuesFile.write(testInfo.getWarningsIssues(), "UTF-8");
                WarningsRecorder recorder = new WarningsRecorder("Package Check", testInfo.getTestName(), "issues.json");
                hasIssues = recorder.record(run, workspace, launcher, listener);
            }
            finally {
                issuesFile.delete();
            }
        }
        return hasIssues;
    }

    public static final class CheckInfoHolder {
        private final String filePath;
        private final Seriousness seriousness;
        private final String errorMessage;
        private final String lineNumber;

        public CheckInfoHolder(String filePath, Seriousness seriousness, String errorMessage, String lineNumber) {
            this.filePath = filePath;
            this.seriousness = seriousness;
            this.errorMessage = errorMessage;
            this.lineNumber = lineNumber;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public Seriousness getSeriousness() {
            return this.seriousness;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getLineNumber() {
            return this.lineNumber;
        }

        public static enum Seriousness {
            NOTE,
            WARNING,
            ERROR;

        }
    }

    protected static class ExecutionInfoHolder
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String testResult;
        private final String testReportDir;
        private final boolean isAborted;

        public ExecutionInfoHolder(String testResult, String testReportDir, boolean isAborted) {
            this.testResult = testResult;
            this.testReportDir = testReportDir;
            this.isAborted = isAborted;
        }

        public String getTestResult() {
            return this.testResult;
        }

        public String getTestReportDir() {
            return this.testReportDir;
        }

        public boolean isAborted() {
            return this.isAborted;
        }
    }

    protected static class TestInfoHolder
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String testName;
        private final String testDescription;
        private String warningsIssues = "";

        public TestInfoHolder(String testName, String testDescription) {
            this.testName = testName;
            this.testDescription = testDescription;
        }

        public String getTestName() {
            return this.testName;
        }

        public String getTestDescription() {
            return this.testDescription;
        }

        public String getWarningsIssues() {
            return this.warningsIssues;
        }

        public void setWarningsIssues(String warningsIssues) {
            this.warningsIssues = warningsIssues;
        }
    }

    protected static final class LoadConfigCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final TestConfig testConfig;
        private final TaskListener listener;

        public LoadConfigCallable(TestConfig testConfig, TaskListener listener) {
            this.testConfig = testConfig;
            this.listener = listener;
        }

        public Boolean call() throws IOException {
            boolean isLoaded = false;
            String tbcFile = this.testConfig.getTbcFile();
            String tcfFile = this.testConfig.getTcfFile();
            List<GlobalConstant> constants = this.testConfig.getConstants();
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);){
                String tbcName = this.getConfigName(tbcFile);
                String tcfName = this.getConfigName(tcfFile);
                logger.logInfo(String.format("- Loading configurations: TBC=%s TCF=%s", tbcName, tcfName));
                logger.logDebug(String.format("TBC=%s", tbcFile));
                logger.logDebug(String.format("TCF=%s", tcfFile));
                if (this.testConfig.isForceReload()) {
                    logger.logInfo("-> Forcing reload configurations...");
                    comClient.stop();
                }
                if (comClient.openTestConfiguration(StringUtils.defaultIfBlank((String)tcfFile, null))) {
                    if (tcfFile != null && !constants.isEmpty()) {
                        Map<String, String> constantMap = this.getGlobalConstantMap();
                        logger.logInfo("-> With global constants: " + constantMap.toString());
                        this.setGlobalConstants(comClient, constantMap);
                    }
                    logger.logInfo("-> Test configuration loaded successfully.");
                } else {
                    logger.logError(String.format("-> Loading TCF=%s failed!", tcfName));
                }
                if (comClient.openTestbenchConfiguration(StringUtils.defaultIfBlank((String)tbcFile, null))) {
                    logger.logInfo("-> Test bench configuration loaded successfully.");
                    isLoaded = true;
                } else {
                    logger.logError(String.format("-> Loading TBC=%s failed!", tbcName));
                }
                if (isLoaded) {
                    if (this.testConfig.isLoadOnly()) {
                        logger.logInfo("-> Starting configurations will be skipped.");
                    } else {
                        logger.logInfo("- Starting configurations...");
                        comClient.start();
                        logger.logInfo("-> Configurations started successfully.");
                    }
                }
            }
            catch (ETComException e) {
                logger.logComException(e);
                isLoaded = false;
            }
            return isLoaded;
        }

        private String getConfigName(String configFile) {
            String configName = StringUtils.isBlank((String)configFile) ? "None" : new File(configFile).getName();
            return configName;
        }

        private void setGlobalConstants(ETComClient comClient, Map<String, String> constantMap) throws ETComException {
            comClient.start();
            TestConfiguration testConfig = (TestConfiguration)comClient.getCurrentTestConfiguration();
            for (Map.Entry<String, String> newConstant : constantMap.entrySet()) {
                testConfig.setGlobalConstant(newConstant.getKey(), newConstant.getValue());
            }
            comClient.stop();
        }

        private Map<String, String> getGlobalConstantMap() {
            LinkedHashMap<String, String> constantMap = new LinkedHashMap<String, String>();
            for (GlobalConstant constant : this.testConfig.getConstants()) {
                constantMap.put(constant.getName(), constant.getValue());
            }
            return constantMap;
        }
    }

    protected static abstract class OpenTestFileCallable
    extends MasterToSlaveCallable<TestInfoHolder, IOException> {
        private final String testFile;
        private final ExpandableConfig testFileConfig;
        private final ExecutionConfig executionConfig;
        private final TaskListener listener;

        public OpenTestFileCallable(String testFile, ExpandableConfig testFileConfig, ExecutionConfig executionConfig, TaskListener listener) {
            this.testFile = testFile;
            this.testFileConfig = testFileConfig;
            this.executionConfig = executionConfig;
            this.listener = listener;
        }

        public String getTestFile() {
            return this.testFile;
        }

        public ExpandableConfig getTestFileConfig() {
            return this.testFileConfig;
        }

        public ExecutionConfig getExecutionConfig() {
            return this.executionConfig;
        }

        public TaskListener getListener() {
            return this.listener;
        }

        public abstract TestInfoHolder call() throws IOException;

        @CheckForNull
        protected TestInfoHolder checkTestFile(AbstractTestObject testObject, ETComClient comClient, TTConsoleLogger logger) throws ETComException {
            String testType;
            TestInfoHolder testInfo = new TestInfoHolder(testObject.getName(), testObject.getDescription());
            String string = testType = testObject instanceof Package ? "package" : "project";
            if (this.executionConfig.isCheckTestFile()) {
                logger.logInfo(String.format("- Checking %s...", testType));
                if (this.executionConfig.isRecordWarnings()) {
                    ToolVersion comVersion = ToolVersion.parse(comClient.getVersion());
                    if (comVersion.compareWithoutMicroTo(new ToolVersion(2020, 3, 0)) >= 0) {
                        logger.logInfo(String.format("-> Recording %s checks as Warnings NG issues...", testType));
                        String checks = testObject.checkNG();
                        testInfo.setWarningsIssues(checks.replace("null", "0"));
                    } else {
                        logger.logInfo(String.format("-> Recording %s checks as Warnings NG issues will be skipped!", testType));
                        logger.logWarn(String.format("The configured ECU-TEST version %s does not support recording WarningNG issues. Please use at least ECU-TEST 2020.3 or higher!", comVersion));
                    }
                } else {
                    List<CheckInfoHolder> checks = testObject.check();
                    for (CheckInfoHolder check : checks) {
                        String logMessage = String.format("%s (line %s): %s", check.getFilePath(), check.getLineNumber(), check.getErrorMessage());
                        CheckInfoHolder.Seriousness seriousness = check.getSeriousness();
                        switch (seriousness) {
                            case NOTE: {
                                logger.logInfo(logMessage);
                                break;
                            }
                            case WARNING: {
                                logger.logWarn(logMessage);
                                break;
                            }
                            case ERROR: {
                                logger.logError(logMessage);
                                testInfo = null;
                                break;
                            }
                        }
                    }
                    if (checks.isEmpty()) {
                        logger.logInfo(String.format("-> %s validated successfully!", StringUtils.capitalize((String)testType)));
                    }
                }
            }
            return testInfo;
        }
    }
}

