/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test;

import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.test.AbstractTestBuilder;
import de.tracetronic.jenkins.plugins.ecutest.test.AbstractTestDescriptor;
import de.tracetronic.jenkins.plugins.ecutest.test.Messages;
import de.tracetronic.jenkins.plugins.ecutest.test.client.ProjectClient;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ExecutionConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ProjectConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.TestConfig;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class TestProjectBuilder
extends AbstractTestBuilder {
    @Nonnull
    private ProjectConfig projectConfig = ProjectConfig.newInstance();

    @DataBoundConstructor
    public TestProjectBuilder(@Nonnull String testFile) {
        super(testFile);
    }

    @Nonnull
    public ProjectConfig getProjectConfig() {
        return this.projectConfig;
    }

    @DataBoundSetter
    public void setProjectConfig(@CheckForNull ProjectConfig projectConfig) {
        this.projectConfig = projectConfig == null ? ProjectConfig.newInstance() : projectConfig;
    }

    @Override
    protected boolean runTest(String testFile, TestConfig testConfig, ExecutionConfig executionConfig, Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        EnvVars buildEnv = run.getEnvironment(listener);
        ProjectConfig projectConfig = this.getProjectConfig().expand(buildEnv);
        ProjectClient testClient = new ProjectClient(testFile, testConfig, projectConfig, executionConfig);
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        logger.logInfo(String.format("Executing project %s...", testFile));
        if (testClient.runTestCase(run, workspace, launcher, listener)) {
            this.addBuildAction(run, testClient);
            if (testClient.isAborted()) {
                logger.logWarn("Project execution aborted!");
                return false;
            }
        } else {
            logger.logError("Executing project failed!");
            return false;
        }
        logger.logInfo("Project executed successfully.");
        return true;
    }

    @Symbol(value={"testProject"})
    @Extension(ordinal=10001.0)
    public static final class DescriptorImpl
    extends AbstractTestDescriptor {
        public DescriptorImpl() {
            super(TestProjectBuilder.class);
            this.load();
        }

        @Override
        public FormValidation doCheckTestFile(@QueryParameter String value) {
            return this.testValidator.validateProjectFile(value);
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.TestProjectBuilder_DisplayName();
        }
    }
}

