/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test;

import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.test.AbstractTestBuilder;
import de.tracetronic.jenkins.plugins.ecutest.test.AbstractTestDescriptor;
import de.tracetronic.jenkins.plugins.ecutest.test.Messages;
import de.tracetronic.jenkins.plugins.ecutest.test.client.PackageClient;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ExecutionConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.PackageConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.TestConfig;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class TestPackageBuilder
extends AbstractTestBuilder {
    @Nonnull
    private PackageConfig packageConfig = PackageConfig.newInstance();

    @DataBoundConstructor
    public TestPackageBuilder(@Nonnull String testFile) {
        super(testFile);
    }

    @Nonnull
    public PackageConfig getPackageConfig() {
        return this.packageConfig;
    }

    @DataBoundSetter
    public void setPackageConfig(@CheckForNull PackageConfig packageConfig) {
        this.packageConfig = packageConfig == null ? PackageConfig.newInstance() : packageConfig;
    }

    @Override
    protected boolean runTest(String testFile, TestConfig testConfig, ExecutionConfig executionConfig, Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        EnvVars buildEnv = run.getEnvironment(listener);
        PackageConfig packageConfig = this.getPackageConfig().expand(buildEnv);
        PackageClient testClient = new PackageClient(testFile, testConfig, packageConfig, executionConfig);
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        logger.logInfo(String.format("Executing package %s...", testFile));
        if (testClient.runTestCase(run, workspace, launcher, listener)) {
            this.addBuildAction(run, testClient);
            if (testClient.isAborted()) {
                logger.logWarn("Package execution aborted!");
                return false;
            }
        } else {
            logger.logError("Executing package failed!");
            return false;
        }
        logger.logInfo("Package executed successfully.");
        return true;
    }

    @Symbol(value={"testPackage"})
    @Extension(ordinal=10002.0)
    public static final class DescriptorImpl
    extends AbstractTestDescriptor {
        public DescriptorImpl() {
            super(TestPackageBuilder.class);
            this.load();
        }

        @Override
        public FormValidation doCheckTestFile(@QueryParameter String value) {
            return this.testValidator.validatePackageFile(value);
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.TestPackageBuilder_DisplayName();
        }
    }
}

