/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test;

import de.tracetronic.jenkins.plugins.ecutest.env.TestEnvInvisibleAction;
import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.tool.client.ETClient;
import de.tracetronic.jenkins.plugins.ecutest.tool.client.TSClient;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComClient;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComException;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComProperty;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.tasks.Builder;
import java.io.File;
import java.io.IOException;
import java.util.List;
import jenkins.security.MasterToSlaveCallable;

public abstract class AbstractTestHelper
extends Builder {
    private static final String DEFAULT_PACKAGES_DIR = "Packages";
    private static final String DEFAULT_CONFIG_DIR = "Configurations";

    public String getDefaultPackagesDir() {
        return DEFAULT_PACKAGES_DIR;
    }

    public String getDefaultConfigDir() {
        return DEFAULT_CONFIG_DIR;
    }

    protected boolean checkETInstance(Launcher launcher, TaskListener listener, boolean kill) throws IOException, InterruptedException {
        List<String> foundProcesses = ETClient.checkProcesses(launcher, listener, kill);
        return !foundProcesses.isEmpty();
    }

    protected boolean closeETInstance(Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        List<String> foundProcesses = ETClient.checkProcesses(launcher, listener, false);
        if (foundProcesses.isEmpty()) {
            return false;
        }
        return ETClient.stopProcesses(launcher, listener, true);
    }

    protected boolean checkTSInstance(Launcher launcher, boolean kill) throws IOException, InterruptedException {
        List<String> foundProcesses = TSClient.checkProcesses(launcher, kill);
        return !foundProcesses.isEmpty();
    }

    protected int getTestId(Run<?, ?> run) {
        List testEnvActions = run.getActions(TestEnvInvisibleAction.class);
        return testEnvActions.size();
    }

    protected String getTestFilePath(String testFile, String pkgDir, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        String testFilePath = null;
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        if (testFile.isEmpty()) {
            logger.logError("No package or project file declared!");
        } else {
            File fullTestFile = new File(pkgDir, testFile);
            FilePath fullTestFilePath = new FilePath(launcher.getChannel(), fullTestFile.getPath());
            if (fullTestFilePath.exists()) {
                testFilePath = fullTestFilePath.getRemote();
            } else {
                logger.logError(String.format("%s does not exist!", fullTestFilePath.getRemote()));
            }
        }
        return testFilePath;
    }

    protected String getConfigFilePath(String configFile, String configDir, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        String configFilePath = null;
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        if (configFile.isEmpty()) {
            configFilePath = configFile;
        } else {
            File fullConfigFile = new File(configDir, configFile);
            FilePath fullConfigFilePath = new FilePath(launcher.getChannel(), fullConfigFile.getPath());
            if (fullConfigFilePath.exists()) {
                configFilePath = fullConfigFilePath.getRemote();
            } else {
                logger.logError(String.format("%s does not exist!", fullConfigFilePath.getRemote()));
            }
        }
        return configFilePath;
    }

    protected String getConfigDir(Launcher launcher, TaskListener listener) throws InterruptedException {
        String configDir;
        try {
            configDir = (String)launcher.getChannel().call((Callable)new GetSettingCallable("configPath"));
        }
        catch (IOException e) {
            TTConsoleLogger logger = new TTConsoleLogger(listener);
            logger.logWarn("Could not get config dir, assuming default values now!");
            configDir = this.getDefaultConfigDir();
        }
        return configDir;
    }

    protected String getPackagesDir(Launcher launcher, TaskListener listener) throws InterruptedException {
        String packagesDir;
        try {
            packagesDir = (String)launcher.getChannel().call((Callable)new GetSettingCallable("packagePath"));
        }
        catch (IOException e) {
            TTConsoleLogger logger = new TTConsoleLogger(listener);
            logger.logWarn("Could not get packages dir, assuming default values now!");
            packagesDir = this.getDefaultPackagesDir();
        }
        return packagesDir;
    }

    public static final class GetSettingCallable
    extends MasterToSlaveCallable<String, IOException> {
        private static final long serialVersionUID = 1L;
        private final String settingName;

        public GetSettingCallable(String settingName) {
            this.settingName = settingName;
        }

        public String call() throws IOException {
            String settingValue;
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);){
                settingValue = comClient.getSetting(this.settingName);
                if ("None".equals(settingValue)) {
                    throw new IOException("Setting is not defined: " + this.settingName);
                }
            }
            catch (ETComException e) {
                throw new IOException(e.getMessage(), e);
            }
            return settingValue;
        }
    }
}

