/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test;

import de.tracetronic.jenkins.plugins.ecutest.ETPluginException;
import de.tracetronic.jenkins.plugins.ecutest.env.TestEnvInvisibleAction;
import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.test.AbstractTestDescriptor;
import de.tracetronic.jenkins.plugins.ecutest.test.AbstractTestHelper;
import de.tracetronic.jenkins.plugins.ecutest.test.client.AbstractTestClient;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ExecutionConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.TestConfig;
import de.tracetronic.jenkins.plugins.ecutest.util.PathUtil;
import de.tracetronic.jenkins.plugins.ecutest.util.ProcessUtil;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.util.IOUtils;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundSetter;

public abstract class AbstractTestBuilder
extends AbstractTestHelper
implements SimpleBuildStep {
    @Nonnull
    private final String testFile;
    @Nonnull
    private TestConfig testConfig = TestConfig.newInstance();
    @Nonnull
    private ExecutionConfig executionConfig = ExecutionConfig.newInstance();

    public AbstractTestBuilder(String testFile) {
        this.testFile = StringUtils.trimToEmpty((String)testFile);
    }

    @Nonnull
    public String getTestFile() {
        return this.testFile;
    }

    @Nonnull
    public TestConfig getTestConfig() {
        return this.testConfig;
    }

    @DataBoundSetter
    public void setTestConfig(@CheckForNull TestConfig testConfig) {
        this.testConfig = testConfig == null ? TestConfig.newInstance() : testConfig;
    }

    @Nonnull
    public ExecutionConfig getExecutionConfig() {
        return this.executionConfig;
    }

    @DataBoundSetter
    public void setExecutionConfig(@CheckForNull ExecutionConfig executionConfig) {
        this.executionConfig = executionConfig == null ? ExecutionConfig.newInstance() : executionConfig;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        try {
            ProcessUtil.checkOS(launcher);
            boolean performed = this.performTest(run, workspace, launcher, listener);
            if (!performed) {
                if (this.getExecutionConfig().isStopOnError()) {
                    logger.logInfo("- Closing running ECU-TEST and Tool-Server instances...");
                    if (this.closeETInstance(launcher, listener)) {
                        logger.logInfo("-> ECU-TEST closed successfully.");
                    } else {
                        logger.logInfo("-> No running ECU-TEST instance found.");
                    }
                    if (this.checkTSInstance(launcher, true)) {
                        logger.logInfo("-> Tool-Server closed successfully.");
                    } else {
                        logger.logInfo("-> No running Tool-Server instance found.");
                    }
                }
                throw new AbortException("Test executions aborted!");
            }
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            throw e;
        }
        catch (ETPluginException e) {
            logger.logError(e.getMessage());
            throw new AbortException(e.getMessage());
        }
    }

    private boolean performTest(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        String expPkgDir;
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        if (!this.checkETInstance(launcher, listener, false)) {
            logger.logError("No running ECU-TEST instance found, please configure one at first!");
            return false;
        }
        EnvVars buildEnv = run.getEnvironment(listener);
        String expTestFile = buildEnv.expand(this.getTestFile());
        TestConfig expTestConfig = this.getTestConfig().expand(buildEnv);
        ExecutionConfig expExecConfig = this.getExecutionConfig().expand(buildEnv);
        if (IOUtils.isAbsolute((String)expTestFile)) {
            expPkgDir = null;
        } else {
            String packageDir = this.getPackagesDir(launcher, listener);
            expPkgDir = PathUtil.makeAbsolutePath(packageDir, workspace);
        }
        String expTestFilePath = this.getTestFilePath(expTestFile, expPkgDir, launcher, listener);
        if (expTestFilePath == null) {
            return false;
        }
        String expTbcFilePath = null;
        String expTcfFilePath = null;
        if (!expTestConfig.isKeepConfig()) {
            String expTbcConfigDir = null;
            String expTcfConfigDir = null;
            String tbcFile = expTestConfig.getTbcFile();
            String tcfFile = expTestConfig.getTcfFile();
            if (!IOUtils.isAbsolute((String)tbcFile) || !IOUtils.isAbsolute((String)tcfFile)) {
                String configDir = this.getConfigDir(launcher, listener);
                String expConfigDir = PathUtil.makeAbsolutePath(configDir, workspace);
                expTbcConfigDir = IOUtils.isAbsolute((String)tbcFile) ? null : expConfigDir;
                expTcfConfigDir = IOUtils.isAbsolute((String)tcfFile) ? null : expConfigDir;
            }
            expTbcFilePath = this.getConfigFilePath(expTestConfig.getTbcFile(), expTbcConfigDir, launcher, listener);
            expTcfFilePath = this.getConfigFilePath(expTestConfig.getTcfFile(), expTcfConfigDir, launcher, listener);
            if (expTbcFilePath == null || expTcfFilePath == null) {
                return false;
            }
        }
        expTestConfig = new TestConfig(expTbcFilePath, expTcfFilePath, expTestConfig.isForceReload(), expTestConfig.isLoadOnly(), expTestConfig.isKeepConfig(), expTestConfig.getConstants());
        return this.runTest(expTestFilePath, expTestConfig, expExecConfig, run, workspace, launcher, listener);
    }

    protected void addBuildAction(Run<?, ?> run, AbstractTestClient testClient) {
        int builderId = this.getTestId(run);
        TestEnvInvisibleAction envAction = new TestEnvInvisibleAction(builderId, testClient);
        run.addAction((Action)envAction);
    }

    protected abstract boolean runTest(String var1, TestConfig var2, ExecutionConfig var3, Run<?, ?> var4, FilePath var5, Launcher var6, TaskListener var7) throws IOException, InterruptedException;

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public AbstractTestDescriptor getDescriptor() {
        return (AbstractTestDescriptor)super.getDescriptor();
    }
}

