/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.test;

import de.tracetronic.jenkins.plugins.ecutest.ETPluginException;
import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.test.AbstractTestHelper;
import de.tracetronic.jenkins.plugins.ecutest.test.client.AbstractTMSClient;
import de.tracetronic.jenkins.plugins.ecutest.test.client.ImportPackageClient;
import de.tracetronic.jenkins.plugins.ecutest.test.client.ImportProjectClient;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportAttributeConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportPackageAttributeConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportPackageConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportProjectArchiveConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportProjectAttributeConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportProjectConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.TMSConfig;
import de.tracetronic.jenkins.plugins.ecutest.util.ProcessUtil;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class AbstractImportBuilder
extends AbstractTestHelper
implements SimpleBuildStep {
    @Nonnull
    private final List<TMSConfig> importConfigs;

    @DataBoundConstructor
    public AbstractImportBuilder(@CheckForNull List<TMSConfig> importConfigs) {
        this.importConfigs = importConfigs == null ? new ArrayList() : AbstractImportBuilder.removeEmptyConfigs(importConfigs);
    }

    private static List<TMSConfig> removeEmptyConfigs(List<TMSConfig> importConfigs) {
        ArrayList<TMSConfig> validConfigs = new ArrayList<TMSConfig>();
        for (TMSConfig config : importConfigs) {
            ImportAttributeConfig pkgAttrConfig;
            if (config instanceof ImportConfig) {
                ImportConfig pkgConfig = (ImportConfig)config;
                if (!StringUtils.isNotBlank((String)pkgConfig.getTmsPath())) continue;
                validConfigs.add(config);
                continue;
            }
            if (!(config instanceof ImportAttributeConfig) || !StringUtils.isNotBlank((String)(pkgAttrConfig = (ImportAttributeConfig)config).getFilePath())) continue;
            validConfigs.add(config);
        }
        return validConfigs;
    }

    @Nonnull
    public List<TMSConfig> getImportConfigs() {
        return Collections.unmodifiableList(this.importConfigs);
    }

    @DataBoundSetter
    public void setImportConfigs(@CheckForNull List<TMSConfig> importConfigs) {
        if (importConfigs != null) {
            this.importConfigs.addAll(importConfigs);
        }
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        try {
            ProcessUtil.checkOS(launcher);
            boolean performed = this.performImport(run, workspace, launcher, listener);
            if (!performed) {
                throw new AbortException("Importing to test management system failed!");
            }
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            throw e;
        }
        catch (ETPluginException e) {
            logger.logError(e.getMessage());
            throw new AbortException(e.getMessage());
        }
    }

    private boolean performImport(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        if (!this.checkETInstance(launcher, listener, false)) {
            logger.logError("No running ECU-TEST instance found, please configure one at first!");
            return false;
        }
        boolean isImported = false;
        for (TMSConfig importConfig : this.importConfigs) {
            AbstractTMSClient importClient;
            EnvVars buildEnv = run.getEnvironment(listener);
            TMSConfig expImportConfig = (TMSConfig)importConfig.expand(buildEnv);
            if (importConfig instanceof ImportPackageConfig) {
                importClient = new ImportPackageClient(expImportConfig);
                isImported = ((ImportPackageClient)importClient).importPackage((Item)run.getParent(), workspace, launcher, listener);
            } else if (importConfig instanceof ImportPackageAttributeConfig) {
                importClient = new ImportPackageClient(expImportConfig);
                isImported = ((ImportPackageClient)importClient).importPackageAttributes((Item)run.getParent(), workspace, launcher, listener);
            } else if (importConfig instanceof ImportProjectConfig) {
                importClient = new ImportProjectClient(expImportConfig);
                isImported = ((ImportProjectClient)importClient).importProject((Item)run.getParent(), workspace, launcher, listener);
            } else if (importConfig instanceof ImportProjectAttributeConfig) {
                importClient = new ImportProjectClient(expImportConfig);
                isImported = ((ImportProjectClient)importClient).importProjectAttributes((Item)run.getParent(), workspace, launcher, listener);
            } else if (importConfig instanceof ImportProjectArchiveConfig) {
                importClient = new ImportProjectClient(expImportConfig);
                isImported = ((ImportProjectClient)importClient).importProjectArchive(launcher, listener);
            } else {
                logger.logError("Unsupported import configuration of type: " + importConfig.getClass());
            }
            if (isImported) continue;
            return false;
        }
        return true;
    }

    public static abstract class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl(Class<? extends AbstractImportBuilder> clazz) {
            super(clazz);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

