/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.trf;

import de.tracetronic.jenkins.plugins.ecutest.ETPluginException;
import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.report.AbstractReportDescriptor;
import de.tracetronic.jenkins.plugins.ecutest.report.AbstractReportPublisher;
import de.tracetronic.jenkins.plugins.ecutest.report.trf.Messages;
import de.tracetronic.jenkins.plugins.ecutest.report.trf.TRFBuildAction;
import de.tracetronic.jenkins.plugins.ecutest.report.trf.TRFReport;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class TRFPublisher
extends AbstractReportPublisher {
    public static final String TRF_EXTENSION = ".trf";
    public static final String TRF_INCLUDE = "*.trf";
    public static final String TRF_INCLUDES = "**/*.trf";
    public static final String TRF_EXCLUDE = "Job_*.trf";
    public static final String TRF_EXCLUDES = "*/**/Job_*.trf";
    protected static final String URL_NAME = "trf-reports";

    @DataBoundConstructor
    public TRFPublisher() {
    }

    @Override
    public void performReport(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException, ETPluginException {
        TTConsoleLogger logger = this.getLogger();
        logger.logInfo("Publishing TRF reports...");
        if (this.isSkipped(false, run, launcher)) {
            return;
        }
        if (this.isArchiving().booleanValue()) {
            ArrayList<TRFReport> trfReports = new ArrayList<TRFReport>();
            FilePath archiveTarget = this.getArchiveTarget(run);
            List<FilePath> reportDirs = this.getReportDirs(run, workspace, launcher);
            if (!reportDirs.isEmpty() && !this.isKeepAll().booleanValue()) {
                archiveTarget.deleteRecursive();
                TRFPublisher.removePreviousReports(run, TRFBuildAction.class);
            }
            for (FilePath reportDir : reportDirs) {
                FilePath archiveTargetDir = archiveTarget.child(reportDir.getName());
                FilePath reportFile = TRFPublisher.getFirstReportFile(reportDir);
                if (reportFile != null && reportFile.exists()) {
                    try {
                        logger.logInfo(String.format("- Archiving TRF report: %s", reportFile));
                        int copiedFiles = reportDir.copyRecursiveTo(TRF_INCLUDES, TRF_EXCLUDES, archiveTargetDir);
                        if (copiedFiles == 0) continue;
                        if (copiedFiles > 1) {
                            logger.logInfo(String.format("-> Archived %d sub-report(s).", copiedFiles - 1));
                        }
                    }
                    catch (IOException e) {
                        Util.displayIOException((IOException)e, (TaskListener)listener);
                        logger.logError("Failed publishing TRF reports.");
                        run.setResult(Result.FAILURE);
                        return;
                    }
                    this.traverseReports(trfReports, archiveTargetDir);
                    continue;
                }
                if (this.isAllowMissing()) continue;
                logger.logError(String.format("Specified TRF file '%s' does not exist.", reportFile));
                run.setResult(Result.FAILURE);
                return;
            }
            if (trfReports.isEmpty() && !this.isAllowMissing()) {
                logger.logError("Empty test results are not allowed, setting build status to FAILURE!");
                run.setResult(Result.FAILURE);
                return;
            }
            this.addBuildAction(run, trfReports);
            logger.logInfo("TRF reports published successfully.");
        } else {
            logger.logInfo("Archiving TRF reports is disabled.");
        }
    }

    private void traverseReports(List<TRFReport> trfReports, FilePath archiveTargetDir) throws IOException, InterruptedException {
        FilePath trfFile = TRFPublisher.getFirstReportFile(archiveTargetDir);
        if (trfFile != null && trfFile.exists()) {
            String relFilePath = archiveTargetDir.getParent().toURI().relativize(trfFile.toURI()).getPath();
            TRFReport trfReport = new TRFReport(TRFPublisher.randomId(), trfFile.getParent().getName(), relFilePath, trfFile.length());
            trfReports.add(trfReport);
            this.traverseSubReports(trfReport, archiveTargetDir.getParent(), archiveTargetDir);
        }
    }

    private void traverseSubReports(TRFReport trfReport, FilePath testReportDir, FilePath subTestReportDir) throws IOException, InterruptedException {
        for (FilePath subDir : subTestReportDir.listDirectories()) {
            FilePath reportFile = TRFPublisher.getFirstReportFile(subDir);
            if (reportFile == null || !reportFile.exists()) continue;
            String relFilePath = testReportDir.toURI().relativize(reportFile.toURI()).getPath();
            TRFReport subReport = new TRFReport(TRFPublisher.randomId(), reportFile.getParent().getName().replaceFirst("^Report\\s", ""), relFilePath, reportFile.length());
            trfReport.addSubReport(subReport);
            this.traverseSubReports(subReport, testReportDir, subDir);
        }
    }

    private void addBuildAction(Run<?, ?> run, List<TRFReport> trfReports) {
        TRFBuildAction action = (TRFBuildAction)run.getAction(TRFBuildAction.class);
        if (action == null) {
            action = new TRFBuildAction(this.isKeepAll() == false);
            run.addAction((Action)action);
        }
        action.addAll(trfReports);
    }

    @Override
    protected String getUrlName() {
        return URL_NAME;
    }

    @Symbol(value={"publishTRF"})
    @Extension(ordinal=10006.0)
    public static final class DescriptorImpl
    extends AbstractReportDescriptor {
        @Nonnull
        public String getDisplayName() {
            return Messages.TRFPublisher_DisplayName();
        }
    }
}

