/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.trf;

import de.tracetronic.jenkins.plugins.ecutest.report.AbstractTestReport;
import de.tracetronic.jenkins.plugins.ecutest.report.trf.AbstractTRFAction;
import de.tracetronic.jenkins.plugins.ecutest.report.trf.Messages;
import de.tracetronic.jenkins.plugins.ecutest.report.trf.TRFProjectAction;
import de.tracetronic.jenkins.plugins.ecutest.report.trf.TRFReport;
import hudson.model.Action;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.tasks.SimpleBuildStep;

public class TRFBuildAction
extends AbstractTRFAction
implements SimpleBuildStep.LastBuildAction {
    private final List<TRFReport> trfReports = new ArrayList<TRFReport>();

    public TRFBuildAction(boolean projectLevel) {
        super(projectLevel);
    }

    public List<TRFReport> getTRFReports() {
        return this.trfReports;
    }

    public void add(TRFReport report) {
        this.trfReports.add(report);
    }

    public void addAll(Collection<TRFReport> reports) {
        this.trfReports.addAll(reports);
    }

    public AbstractTestReport getDynamic(String token) {
        for (TRFReport report : this.getTRFReports()) {
            if (token.equals(report.getId())) {
                return report;
            }
            TRFReport potentialReport = this.traverseSubReports(token, report);
            if (potentialReport == null) continue;
            return potentialReport;
        }
        return null;
    }

    private TRFReport traverseSubReports(String token, TRFReport report) {
        for (AbstractTestReport subReport : report.getSubReports()) {
            if (token.equals(subReport.getId())) {
                return (TRFReport)subReport;
            }
            TRFReport potentialReport = this.traverseSubReports(token, (TRFReport)subReport);
            if (potentialReport == null) continue;
            return potentialReport;
        }
        return null;
    }

    public String getDisplayName() {
        return Messages.TRFBuildAction_DisplayName();
    }

    public Collection<? extends Action> getProjectActions() {
        return Collections.singleton(new TRFProjectAction(this.isProjectLevel()));
    }
}

