/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.ta;

import de.tracetronic.jenkins.plugins.ecutest.ETPluginException;
import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.report.AbstractReportDescriptor;
import de.tracetronic.jenkins.plugins.ecutest.report.AbstractToolPublisher;
import de.tracetronic.jenkins.plugins.ecutest.report.ta.Messages;
import de.tracetronic.jenkins.plugins.ecutest.report.ta.TraceAnalysisBuildAction;
import de.tracetronic.jenkins.plugins.ecutest.report.ta.TraceAnalysisReport;
import de.tracetronic.jenkins.plugins.ecutest.report.ta.TraceAnalysisRunner;
import de.tracetronic.jenkins.plugins.ecutest.tool.client.ETClient;
import de.tracetronic.jenkins.plugins.ecutest.util.validation.TestValidator;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class TraceAnalysisPublisher
extends AbstractToolPublisher {
    protected static final int DEFAULT_TIMEOUT = 3600;
    protected static final String URL_NAME = "trace-analysis";
    private boolean mergeReports = true;
    private boolean createReportDir = false;
    private String timeout = String.valueOf(TraceAnalysisPublisher.getDefaultTimeout());

    @DataBoundConstructor
    public TraceAnalysisPublisher(@Nonnull String toolName) {
        super(toolName);
    }

    public static int parse(String param) {
        try {
            return Integer.parseInt(param);
        }
        catch (NumberFormatException e) {
            return 3600;
        }
    }

    public static int getDefaultTimeout() {
        return 3600;
    }

    public boolean isMergeReports() {
        return this.mergeReports;
    }

    @DataBoundSetter
    public void setMergeReports(boolean mergeReports) {
        this.mergeReports = mergeReports;
    }

    public boolean isCreateReportDir() {
        return this.createReportDir;
    }

    @DataBoundSetter
    public void setCreateReportDir(boolean createReportDir) {
        this.createReportDir = createReportDir;
    }

    public int getParsedTimeout() {
        return TraceAnalysisPublisher.parse(this.getTimeout());
    }

    public String getTimeout() {
        return this.timeout;
    }

    @DataBoundSetter
    public void setTimeout(@CheckForNull String timeout) {
        this.timeout = StringUtils.defaultIfBlank((String)timeout, (String)String.valueOf(TraceAnalysisPublisher.getDefaultTimeout()));
    }

    @Override
    protected void performReport(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException, ETPluginException {
        TTConsoleLogger logger = this.getLogger();
        logger.logInfo("Publishing trace analysis...");
        if (this.isSkipped(true, run, launcher)) {
            return;
        }
        Map<FilePath, List<FilePath>> analysisFiles = this.getAnalysisFiles(run, workspace, launcher);
        if (analysisFiles.isEmpty() && !this.isAllowMissing()) {
            throw new ETPluginException("Empty analysis results are not allowed, setting build status to FAILURE!");
        }
        boolean isPublished = false;
        ArrayList<TraceAnalysisReport> reports = new ArrayList<TraceAnalysisReport>();
        if (this.isETRunning(launcher, listener)) {
            reports.addAll(this.performAnalysis(analysisFiles, run, launcher, listener));
            isPublished = true;
        } else {
            ETClient etClient = this.getToolClient(run, workspace, launcher, listener);
            if (etClient.start(false, workspace, launcher, listener)) {
                reports.addAll(this.performAnalysis(analysisFiles, run, launcher, listener));
                isPublished = true;
            } else {
                logger.logError(String.format("Starting %s failed.", this.getToolName()));
            }
            if (!etClient.stop(true, workspace, launcher, listener)) {
                logger.logError(String.format("Stopping %s failed.", this.getToolName()));
            }
        }
        if (this.isArchiving().booleanValue()) {
            this.addBuildAction(run, reports);
        } else {
            logger.logInfo("Archiving trace analysis reports is disabled.");
        }
        if (isPublished) {
            logger.logInfo("Trace analysis reports published successfully.");
        } else {
            logger.logInfo("Failed publishing trace analysis reports.");
            run.setResult(Result.FAILURE);
        }
    }

    private List<TraceAnalysisReport> performAnalysis(Map<FilePath, List<FilePath>> analysisFiles, Run<?, ?> run, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        TTConsoleLogger logger = this.getLogger();
        ArrayList<TraceAnalysisReport> reports = new ArrayList<TraceAnalysisReport>();
        FilePath archiveTarget = this.prepareArchive(run);
        for (Map.Entry<FilePath, List<FilePath>> analysisEntry : analysisFiles.entrySet()) {
            FilePath reportDir = analysisEntry.getKey();
            List<FilePath> jobFiles = analysisEntry.getValue();
            FilePath archiveTargetDir = archiveTarget.child(reportDir.getBaseName());
            TraceAnalysisRunner runner = new TraceAnalysisRunner();
            List<FilePath> reportFiles = runner.runAnalysis(jobFiles, this.isCreateReportDir(), this.getParsedTimeout(), launcher, listener);
            if (reportFiles.isEmpty() && !this.isAllowMissing()) {
                logger.logError("-> Empty analysis results are not allowed, setting build status to FAILURE!");
                run.setResult(Result.FAILURE);
            }
            if (this.isMergeReports()) {
                FilePath mainReport = TraceAnalysisPublisher.getFirstReportFile(reportDir);
                if (mainReport == null) {
                    logger.logError("-> No main report found, setting build status to FAILURE!");
                    run.setResult(Result.FAILURE);
                    continue;
                }
                boolean isMerged = runner.mergeReports(mainReport, reportFiles, launcher, listener);
                if (!isMerged) {
                    logger.logError("-> Failed merging analysis reports, setting build status to FAILURE!");
                    run.setResult(Result.FAILURE);
                }
                if (!this.isArchiving().booleanValue()) continue;
                logger.logInfo(String.format("- Archiving main report: %s", mainReport));
                this.archiveReport(mainReport, archiveTargetDir, run, logger);
                this.addReport(reports, reportDir, mainReport);
                continue;
            }
            if (!this.isArchiving().booleanValue()) continue;
            for (FilePath reportFile : reportFiles) {
                logger.logInfo(String.format("- Archiving analysis report: %s", reportFile));
                FilePath targetDir = this.isCreateReportDir() ? archiveTargetDir.getParent().child(reportFile.getParent().getName()) : archiveTargetDir.child(reportFile.getParent().getName());
                this.archiveReport(reportFile, targetDir, run, logger);
                this.addReport(reports, reportDir, reportFile);
            }
        }
        return reports;
    }

    private FilePath prepareArchive(Run<?, ?> run) throws IOException, InterruptedException {
        FilePath archiveTarget = this.getArchiveTarget(run);
        archiveTarget.mkdirs();
        if (!this.isKeepAll().booleanValue()) {
            archiveTarget.deleteRecursive();
            TraceAnalysisPublisher.removePreviousReports(run, TraceAnalysisBuildAction.class);
        }
        return archiveTarget;
    }

    private void archiveReport(FilePath reportFile, FilePath archiveTarget, Run<?, ?> run, TTConsoleLogger logger) throws IOException, InterruptedException {
        if (reportFile.exists()) {
            reportFile.copyTo(archiveTarget.child(reportFile.getName()));
        } else if (!this.isAllowMissing()) {
            logger.logError(String.format("-> Specified report file '%s' does not exist.", reportFile.getName()));
            run.setResult(Result.FAILURE);
        }
    }

    private void addReport(List<TraceAnalysisReport> reports, FilePath targetDir, FilePath report) throws IOException, InterruptedException {
        String relFilePath = targetDir.getParent().toURI().relativize(report.toURI()).getPath();
        TraceAnalysisReport trfReport = new TraceAnalysisReport(TraceAnalysisPublisher.randomId(), report.getParent().getName(), relFilePath, report.length());
        reports.add(trfReport);
    }

    private Map<FilePath, List<FilePath>> getAnalysisFiles(Run<?, ?> run, FilePath workspace, Launcher launcher) throws IOException, InterruptedException {
        LinkedHashMap<FilePath, List<FilePath>> analysisFiles = new LinkedHashMap<FilePath, List<FilePath>>();
        List<FilePath> reportDirs = this.getReportDirs(run, workspace, launcher);
        for (FilePath reportDir : reportDirs) {
            List<FilePath> jobFiles = Arrays.asList(reportDir.list("**/*.ajob"));
            Collections.reverse(jobFiles);
            analysisFiles.put(reportDir, jobFiles);
        }
        return analysisFiles;
    }

    private void addBuildAction(Run<?, ?> run, List<TraceAnalysisReport> analysisReports) {
        TraceAnalysisBuildAction action = (TraceAnalysisBuildAction)run.getAction(TraceAnalysisBuildAction.class);
        if (action == null) {
            action = new TraceAnalysisBuildAction(this.isKeepAll() == false);
            run.addAction((Action)action);
        }
        action.addAll(analysisReports);
    }

    @Override
    protected String getUrlName() {
        return URL_NAME;
    }

    @Symbol(value={"publishTraceAnalysis"})
    @Extension(ordinal=10002.0)
    public static final class DescriptorImpl
    extends AbstractReportDescriptor {
        private final TestValidator testValidator = new TestValidator();

        public static int getDefaultTimeout() {
            return 3600;
        }

        public FormValidation doCheckTimeout(@QueryParameter String value) {
            return this.testValidator.validateTimeout(value, DescriptorImpl.getDefaultTimeout());
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.TraceAnalysisPublisher_DisplayName();
        }
    }
}

