/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.ta;

import de.tracetronic.jenkins.plugins.ecutest.report.AbstractTestReport;
import de.tracetronic.jenkins.plugins.ecutest.report.ta.AbstractTraceAnalysisAction;
import de.tracetronic.jenkins.plugins.ecutest.report.ta.Messages;
import de.tracetronic.jenkins.plugins.ecutest.report.ta.TraceAnalysisProjectAction;
import de.tracetronic.jenkins.plugins.ecutest.report.ta.TraceAnalysisReport;
import hudson.model.Action;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.tasks.SimpleBuildStep;

public class TraceAnalysisBuildAction
extends AbstractTraceAnalysisAction
implements SimpleBuildStep.LastBuildAction {
    private final List<TraceAnalysisReport> taReports = new ArrayList<TraceAnalysisReport>();

    public TraceAnalysisBuildAction(boolean projectLevel) {
        super(projectLevel);
    }

    public List<TraceAnalysisReport> getTraceAnalysisReports() {
        return this.taReports;
    }

    public void add(TraceAnalysisReport report) {
        this.taReports.add(report);
    }

    public void addAll(Collection<TraceAnalysisReport> reports) {
        this.taReports.addAll(reports);
    }

    public AbstractTestReport getDynamic(String token) {
        for (TraceAnalysisReport report : this.getTraceAnalysisReports()) {
            if (token.equals(report.getId())) {
                return report;
            }
            TraceAnalysisReport potentialReport = this.traverseSubReports(token, report);
            if (potentialReport == null) continue;
            return potentialReport;
        }
        return null;
    }

    private TraceAnalysisReport traverseSubReports(String token, TraceAnalysisReport report) {
        for (AbstractTestReport subReport : report.getSubReports()) {
            if (token.equals(subReport.getId())) {
                return (TraceAnalysisReport)subReport;
            }
            TraceAnalysisReport potentialReport = this.traverseSubReports(token, (TraceAnalysisReport)subReport);
            if (potentialReport == null) continue;
            return potentialReport;
        }
        return null;
    }

    public String getDisplayName() {
        return Messages.TraceAnalysisBuildAction_DisplayName();
    }

    public Collection<? extends Action> getProjectActions() {
        return Collections.singleton(new TraceAnalysisProjectAction(this.isProjectLevel()));
    }
}

