/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.log;

import de.tracetronic.jenkins.plugins.ecutest.report.AbstractTestReport;
import de.tracetronic.jenkins.plugins.ecutest.report.log.AbstractETLogAction;
import de.tracetronic.jenkins.plugins.ecutest.report.log.ETLogProjectAction;
import de.tracetronic.jenkins.plugins.ecutest.report.log.ETLogReport;
import de.tracetronic.jenkins.plugins.ecutest.report.log.Messages;
import hudson.model.Action;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.tasks.SimpleBuildStep;

public class ETLogBuildAction
extends AbstractETLogAction
implements SimpleBuildStep.LastBuildAction {
    private final List<ETLogReport> logReports = new ArrayList<ETLogReport>();

    public ETLogBuildAction(boolean projectLevel) {
        super(projectLevel);
    }

    public List<ETLogReport> getLogReports() {
        return this.logReports;
    }

    public void add(ETLogReport report) {
        this.logReports.add(report);
    }

    public void addAll(Collection<ETLogReport> reports) {
        this.logReports.addAll(reports);
    }

    public ETLogReport getDynamic(String token) {
        for (ETLogReport report : this.getLogReports()) {
            if (token.equals(report.getId())) {
                return report;
            }
            ETLogReport potentialReport = this.traverseSubReports(token, report);
            if (potentialReport == null) continue;
            return potentialReport;
        }
        return null;
    }

    private ETLogReport traverseSubReports(String token, ETLogReport report) {
        for (AbstractTestReport subReport : report.getSubReports()) {
            if (token.equals(subReport.getId())) {
                return (ETLogReport)subReport;
            }
            ETLogReport potentialReport = this.traverseSubReports(token, (ETLogReport)subReport);
            if (potentialReport == null) continue;
            return potentialReport;
        }
        return null;
    }

    public String getDisplayName() {
        return Messages.ETLogBuildAction_DisplayName();
    }

    public Collection<? extends Action> getProjectActions() {
        return Collections.singleton(new ETLogProjectAction(this.isProjectLevel()));
    }
}

