/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.junit;

import de.tracetronic.jenkins.plugins.ecutest.env.ToolEnvInvisibleAction;
import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.tool.client.ETClient;
import de.tracetronic.jenkins.plugins.ecutest.tool.client.ETComRegisterClient;
import de.tracetronic.jenkins.plugins.ecutest.tool.installation.ETInstallation;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComClient;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComException;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComProperty;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.TestEnvironment;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.IOException;
import java.util.List;
import jenkins.security.MasterToSlaveCallable;

public class JUnitReportGenerator {
    public boolean generate(ETInstallation installation, List<FilePath> reportFiles, Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        boolean isETRunning;
        boolean isGenerated = false;
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        List<String> foundProcesses = ETClient.checkProcesses(launcher, listener, false);
        boolean bl = isETRunning = !foundProcesses.isEmpty();
        if (isETRunning) {
            isGenerated = this.generateReports(reportFiles, launcher, listener);
        } else {
            String settingsDir;
            String workspaceDir;
            ETClient etClient;
            String installPath;
            String toolName = run.getEnvironment(listener).expand(installation.getName());
            if (installation.isRegisterComServer()) {
                installPath = installation.getComExecutable(launcher);
                ETComRegisterClient comClient = new ETComRegisterClient(toolName, installPath);
                comClient.start(false, workspace, launcher, listener);
            }
            if ((etClient = new ETClient(toolName, installPath = installation.getExecutable(launcher), workspaceDir = this.getWorkspaceDir(run), settingsDir = this.getSettingsDir(run), 120, false)).start(false, workspace, launcher, listener)) {
                isGenerated = this.generateReports(reportFiles, launcher, listener);
            } else {
                logger.logError(String.format("Starting %s failed.", toolName));
            }
            if (!etClient.stop(true, workspace, launcher, listener)) {
                logger.logError(String.format("Stopping %s failed.", toolName));
            }
        }
        return isGenerated;
    }

    private boolean generateReports(List<FilePath> reportFiles, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        logger.logInfo("- Generating UNIT test reports...");
        return (Boolean)launcher.getChannel().call((Callable)new GenerateUnitReportCallable(reportFiles, listener));
    }

    private String getWorkspaceDir(Run<?, ?> run) {
        String workspaceDir = "";
        ToolEnvInvisibleAction toolEnvAction = (ToolEnvInvisibleAction)run.getAction(ToolEnvInvisibleAction.class);
        if (toolEnvAction != null) {
            workspaceDir = toolEnvAction.getToolWorkspace();
        }
        return workspaceDir;
    }

    private String getSettingsDir(Run<?, ?> run) {
        String settingsDir = "";
        ToolEnvInvisibleAction toolEnvAction = (ToolEnvInvisibleAction)run.getAction(ToolEnvInvisibleAction.class);
        if (toolEnvAction != null) {
            settingsDir = toolEnvAction.getToolSettings();
        }
        return settingsDir;
    }

    private static final class GenerateUnitReportCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final List<FilePath> dbFiles;
        private final TaskListener listener;

        GenerateUnitReportCallable(List<FilePath> dbFiles, TaskListener listener) {
            this.dbFiles = dbFiles;
            this.listener = listener;
        }

        public Boolean call() throws IOException {
            boolean isGenerated = true;
            TTConsoleLogger logger = new TTConsoleLogger(this.listener);
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);){
                TestEnvironment testEnv = (TestEnvironment)comClient.getTestEnvironment();
                for (FilePath dbFile : this.dbFiles) {
                    logger.logInfo(String.format("-> Generating UNIT report: %s", dbFile.getRemote()));
                    FilePath outDir = dbFile.getParent().child("UNIT");
                    if (testEnv.generateTestReportDocumentFromDB(dbFile.getRemote(), outDir.getRemote(), "UNIT", true)) continue;
                    isGenerated = false;
                    logger.logError("Generating UNIT report failed!");
                }
            }
            catch (ETComException e) {
                isGenerated = false;
                logger.logComException(e);
            }
            return isGenerated;
        }
    }
}

