/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.generator;

import de.tracetronic.jenkins.plugins.ecutest.test.config.ExpandableConfig;
import de.tracetronic.jenkins.plugins.ecutest.util.validation.ReportGeneratorValidator;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ReportGeneratorSetting
extends AbstractDescribableImpl<ReportGeneratorSetting>
implements ExpandableConfig,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String value;

    @DataBoundConstructor
    public ReportGeneratorSetting(String name, String value) {
        this.name = StringUtils.trimToEmpty((String)name);
        this.value = StringUtils.trimToEmpty((String)value);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public ReportGeneratorSetting expand(EnvVars envVars) {
        String expandedName = envVars.expand(this.getName());
        String expandedValue = envVars.expand(this.getValue());
        return new ReportGeneratorSetting(expandedName, expandedValue);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ReportGeneratorSetting> {
        private final ReportGeneratorValidator reportValidator = new ReportGeneratorValidator();

        public FormValidation doCheckName(@QueryParameter String value) {
            return this.reportValidator.validateSettingName(value);
        }

        public FormValidation doCheckValue(@QueryParameter String value) {
            return this.reportValidator.validateSettingValue(value);
        }

        @Nonnull
        public String getDisplayName() {
            return "Report Generator Setting";
        }
    }
}

