/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.generator;

import de.tracetronic.jenkins.plugins.ecutest.ETPluginException;
import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.report.AbstractReportDescriptor;
import de.tracetronic.jenkins.plugins.ecutest.report.AbstractToolPublisher;
import de.tracetronic.jenkins.plugins.ecutest.report.generator.GeneratorReport;
import de.tracetronic.jenkins.plugins.ecutest.report.generator.Messages;
import de.tracetronic.jenkins.plugins.ecutest.report.generator.ReportGenerator;
import de.tracetronic.jenkins.plugins.ecutest.report.generator.ReportGeneratorBuildAction;
import de.tracetronic.jenkins.plugins.ecutest.report.generator.ReportGeneratorConfig;
import de.tracetronic.jenkins.plugins.ecutest.tool.client.ETClient;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ReportGeneratorPublisher
extends AbstractToolPublisher {
    protected static final String URL_NAME = "generator-reports";
    @Nonnull
    private List<ReportGeneratorConfig> generators = new ArrayList<ReportGeneratorConfig>();
    @Nonnull
    private List<ReportGeneratorConfig> customGenerators = new ArrayList<ReportGeneratorConfig>();

    @DataBoundConstructor
    public ReportGeneratorPublisher(@Nonnull String toolName) {
        super(toolName);
    }

    private static List<ReportGeneratorConfig> removeEmptyGenerators(List<ReportGeneratorConfig> generators) {
        ArrayList<ReportGeneratorConfig> validGenerators = new ArrayList<ReportGeneratorConfig>();
        for (ReportGeneratorConfig generator : generators) {
            if (!StringUtils.isNotBlank((String)generator.getName())) continue;
            validGenerators.add(generator);
        }
        return validGenerators;
    }

    @Nonnull
    public List<ReportGeneratorConfig> getGenerators() {
        return this.generators;
    }

    @DataBoundSetter
    public void setGenerators(List<ReportGeneratorConfig> generators) {
        this.generators = generators == null ? new ArrayList() : ReportGeneratorPublisher.removeEmptyGenerators(generators);
    }

    @Nonnull
    public List<ReportGeneratorConfig> getCustomGenerators() {
        return this.customGenerators;
    }

    @DataBoundSetter
    public void setCustomGenerators(List<ReportGeneratorConfig> customGenerators) {
        this.customGenerators = customGenerators == null ? new ArrayList() : ReportGeneratorPublisher.removeEmptyGenerators(customGenerators);
    }

    @Override
    public void performReport(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException, ETPluginException {
        TTConsoleLogger logger = this.getLogger();
        logger.logInfo("Publishing generator reports...");
        if (this.isSkipped(true, run, launcher)) {
            return;
        }
        List<FilePath> reportFiles = this.getReportFiles(run, workspace, launcher);
        if (reportFiles.isEmpty() && !this.isAllowMissing()) {
            throw new ETPluginException("Empty test results are not allowed, setting build status to FAILURE!");
        }
        ArrayList<GeneratorReport> reports = new ArrayList<GeneratorReport>();
        if (this.isETRunning(launcher, listener)) {
            reports.addAll(this.generateReports(reportFiles, run, workspace, launcher, listener));
        } else {
            ETClient etClient = this.getToolClient(run, workspace, launcher, listener);
            if (etClient.start(false, workspace, launcher, listener)) {
                reports.addAll(this.generateReports(reportFiles, run, workspace, launcher, listener));
            } else {
                logger.logError(String.format("Starting %s failed.", this.getToolName()));
            }
            if (!etClient.stop(true, workspace, launcher, listener)) {
                logger.logError(String.format("Stopping %s failed.", this.getToolName()));
            }
        }
        if (this.isArchiving().booleanValue()) {
            this.addBuildAction(run, reports);
        } else {
            logger.logInfo("Archiving TRF reports is disabled.");
        }
        logger.logInfo("Generator reports published successfully.");
    }

    private List<GeneratorReport> generateReports(List<FilePath> reportFiles, Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        TTConsoleLogger logger = this.getLogger();
        ArrayList<GeneratorReport> reports = new ArrayList<GeneratorReport>();
        FilePath archiveTarget = this.getArchiveTarget(run);
        ArrayList<ReportGeneratorConfig> generators = new ArrayList<ReportGeneratorConfig>();
        generators.addAll(this.getGenerators());
        generators.addAll(this.getCustomGenerators());
        if (!reportFiles.isEmpty() && !this.isKeepAll().booleanValue()) {
            archiveTarget.deleteRecursive();
            ReportGeneratorPublisher.removePreviousReports(run, ReportGeneratorBuildAction.class);
        }
        for (ReportGeneratorConfig config : generators) {
            EnvVars envVars = run.getEnvironment(listener);
            ReportGeneratorConfig expConfig = config.expand(envVars);
            ReportGenerator generator = new ReportGenerator(expConfig);
            boolean isGenerated = generator.generate(reportFiles, launcher, listener);
            if (!this.isArchiving().booleanValue() || !isGenerated || reportFiles.isEmpty()) continue;
            logger.logInfo("- Archiving generated reports...");
            String templateName = expConfig.getName();
            FilePath archiveTargetDir = archiveTarget.child(templateName);
            List<FilePath> reportDirs = this.getReportDirs(run, workspace, launcher);
            for (FilePath reportDir : reportDirs) {
                try {
                    int copiedFiles = reportDir.copyRecursiveTo(String.format("**/%s/**", templateName), archiveTargetDir.child(reportDir.getName()));
                    logger.logInfo(String.format("-> Archived %d report file(s).", copiedFiles));
                }
                catch (IOException e) {
                    Util.displayIOException((IOException)e, (TaskListener)listener);
                    logger.logError("Failed archiving generated reports.");
                }
            }
            if (!archiveTargetDir.exists()) continue;
            GeneratorReport report = new GeneratorReport(ReportGeneratorPublisher.randomId(), templateName, templateName, this.getDirectorySize(archiveTargetDir));
            reports.add(report);
            for (FilePath reportDir : reportDirs) {
                GeneratorReport subReport = new GeneratorReport(ReportGeneratorPublisher.randomId(), reportDir.getBaseName(), String.format("%s/%s", templateName, reportDir.getBaseName()), this.getDirectorySize(reportDir));
                report.addSubReport(subReport);
            }
        }
        return reports;
    }

    private void addBuildAction(Run<?, ?> run, List<GeneratorReport> reports) {
        ReportGeneratorBuildAction action = (ReportGeneratorBuildAction)run.getAction(ReportGeneratorBuildAction.class);
        if (action == null) {
            action = new ReportGeneratorBuildAction(this.isKeepAll() == false);
            run.addAction((Action)action);
        }
        action.addAll(reports);
    }

    @Override
    protected String getUrlName() {
        return URL_NAME;
    }

    @Symbol(value={"publishGenerators"})
    @Extension(ordinal=10004.0)
    public static class DescriptorImpl
    extends AbstractReportDescriptor {
        @Nonnull
        public String getDisplayName() {
            return Messages.ReportGeneratorPublisher_DisplayName();
        }
    }
}

