/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.generator;

import de.tracetronic.jenkins.plugins.ecutest.report.AbstractTestReport;
import de.tracetronic.jenkins.plugins.ecutest.report.generator.AbstractReportGeneratorAction;
import de.tracetronic.jenkins.plugins.ecutest.report.generator.GeneratorReport;
import de.tracetronic.jenkins.plugins.ecutest.report.generator.Messages;
import de.tracetronic.jenkins.plugins.ecutest.report.generator.ReportGeneratorProjectAction;
import hudson.model.Action;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.tasks.SimpleBuildStep;

public class ReportGeneratorBuildAction
extends AbstractReportGeneratorAction
implements SimpleBuildStep.LastBuildAction {
    private final List<GeneratorReport> generatorReports = new ArrayList<GeneratorReport>();

    public ReportGeneratorBuildAction(boolean projectLevel) {
        super(projectLevel);
    }

    public List<GeneratorReport> getGeneratorReports() {
        return this.generatorReports;
    }

    public void add(GeneratorReport report) {
        this.generatorReports.add(report);
    }

    public void addAll(Collection<GeneratorReport> reports) {
        this.generatorReports.addAll(reports);
    }

    public AbstractTestReport getDynamic(String token) {
        for (GeneratorReport report : this.getGeneratorReports()) {
            if (token.equals(report.getId())) {
                return report;
            }
            GeneratorReport potentialReport = this.traverseSubReports(token, report);
            if (potentialReport == null) continue;
            return potentialReport;
        }
        return null;
    }

    private GeneratorReport traverseSubReports(String token, GeneratorReport report) {
        for (AbstractTestReport subReport : report.getSubReports()) {
            if (token.equals(subReport.getId())) {
                return (GeneratorReport)subReport;
            }
            GeneratorReport potentialReport = this.traverseSubReports(token, (GeneratorReport)subReport);
            if (potentialReport == null) continue;
            return potentialReport;
        }
        return null;
    }

    public String getDisplayName() {
        return Messages.ReportGeneratorBuildAction_DisplayName();
    }

    public Collection<? extends Action> getProjectActions() {
        return Collections.singleton(new ReportGeneratorProjectAction(this.isProjectLevel()));
    }
}

