/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.atx.pipeline;

import com.google.common.collect.Maps;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXInstallation;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXSetting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.cps.CpsScript;

public class ATXServer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ATXInstallation installation;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private transient CpsScript script;

    public ATXServer(ATXInstallation installation) {
        this.installation = installation;
    }

    @Whitelisted
    public ATXInstallation getInstallation() {
        return this.installation;
    }

    public void setScript(CpsScript script) {
        this.script = script;
    }

    @Whitelisted
    public void publish() {
        this.publish(false, false, true, true);
    }

    @Whitelisted
    public void publish(boolean allowMissing, boolean runOnFailed, boolean archiving, boolean keepAll) {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put("atxName", this.installation.getName());
        stepVariables.put("atxInstallation", this.installation);
        stepVariables.put("allowMissing", allowMissing);
        stepVariables.put("runOnFailed", runOnFailed);
        stepVariables.put("archiving", archiving);
        stepVariables.put("keepAll", keepAll);
        this.script.invokeMethod("publishATX", (Object)stepVariables);
    }

    @Whitelisted
    public void publish(Map<String, Object> settings) {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put("atxName", this.installation.getName());
        stepVariables.put("atxInstallation", this.installation);
        stepVariables.putAll(settings);
        this.script.invokeMethod("publishATX", (Object)stepVariables);
    }

    @Whitelisted
    public ATXSetting<?> getSetting(String settingName) {
        return this.installation.getConfig().getSettingByName(settingName).orElse(null);
    }

    @Whitelisted
    public Map<String, Object> getSettings() {
        LinkedHashMap<String, Object> settings = new LinkedHashMap<String, Object>();
        this.installation.getConfig().getSettings().forEach(setting -> settings.put(setting.getName(), setting.getValue()));
        return settings;
    }

    @Whitelisted
    public void overrideSetting(String settingName, Object settingValue) {
        Optional<ATXSetting<?>> setting = this.installation.getConfig().getSettingByName(settingName);
        if (setting.isPresent()) {
            if (settingValue instanceof String || settingValue instanceof Boolean) {
                this.script.println((Object)String.format("[TT] INFO: Overriding ATX setting %s=%s", settingName, settingValue));
                this.installation.getConfig().setSettingValueByName(settingName, settingValue);
            } else {
                this.script.println((Object)"[TT] WARN: Ignore overriding ATX setting due to invalid value!");
            }
        } else {
            this.script.println((Object)"[TT] WARN: Ignore overriding ATX setting due to invalid key!");
        }
    }

    @Whitelisted
    public void overrideSettings(Map<String, Object> settings) {
        settings.forEach(this::overrideSetting);
    }
}

