/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.atx.pipeline;

import com.google.common.collect.Maps;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXConfig;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.pipeline.ATXServer;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.cps.CpsScript;

public class ATXPipeline
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String KEY_ATX_NAME = "atxName";
    private static final String KEY_TOOL_NAME = "toolName";
    private static final String KEY_SERVER_URL = "fullServerURL";
    private static final String KEY_CONFIG = "config";
    private final CpsScript script;

    public ATXPipeline(CpsScript script) {
        this.script = script;
    }

    @Whitelisted
    public ATXServer server(String serverName) {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put(KEY_ATX_NAME, serverName);
        ATXServer server = (ATXServer)this.script.invokeMethod("getATXServer", (Object)stepVariables);
        server.setScript(this.script);
        return server;
    }

    @Whitelisted
    public ATXServer server(Map<String, Object> serverArgs) {
        List<String> keysAsList = Collections.singletonList(KEY_ATX_NAME);
        if (!keysAsList.containsAll(serverArgs.keySet())) {
            throw new IllegalArgumentException("The server method requires the following arguments at least: " + keysAsList);
        }
        ATXServer server = (ATXServer)this.script.invokeMethod("getATXServer", serverArgs);
        server.setScript(this.script);
        return server;
    }

    @Whitelisted
    public ATXServer newServer(String atxName, String toolName) {
        return this.newServer(atxName, toolName, new ATXConfig());
    }

    @Whitelisted
    public ATXServer newServer(String atxName, String toolName, ATXConfig config) {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put(KEY_ATX_NAME, atxName);
        stepVariables.put(KEY_TOOL_NAME, toolName);
        stepVariables.put(KEY_CONFIG, config);
        ATXServer server = (ATXServer)this.script.invokeMethod("newATXServer", (Object)stepVariables);
        server.setScript(this.script);
        return server;
    }

    @Whitelisted
    public ATXServer newServer(String atxName, String toolName, String fullServerUrl, boolean uploadToServer, String authKey, String projectId) throws MalformedURLException {
        LinkedHashMap additionalSettings = Maps.newLinkedHashMap();
        additionalSettings.put("uploadToServer", uploadToServer);
        additionalSettings.put("uploadAuthenticationKey", authKey);
        additionalSettings.put("projectId", projectId);
        return this.newServer(atxName, toolName, fullServerUrl, additionalSettings);
    }

    @Whitelisted
    public ATXServer newServer(Map<String, Object> serverArgs) throws MalformedURLException {
        ArrayList<String> requiredKeys = new ArrayList<String>(Arrays.asList(KEY_ATX_NAME, KEY_TOOL_NAME));
        if (!serverArgs.keySet().containsAll(requiredKeys)) {
            throw new IllegalArgumentException("The newServer method requires the following arguments at least: " + requiredKeys);
        }
        if (serverArgs.containsKey(KEY_CONFIG) && serverArgs.get(KEY_CONFIG) instanceof ATXConfig) {
            return this.newServer(serverArgs.get(KEY_ATX_NAME).toString(), serverArgs.get(KEY_TOOL_NAME).toString(), (ATXConfig)serverArgs.get(KEY_CONFIG));
        }
        requiredKeys.add(KEY_SERVER_URL);
        HashMap<String, Object> additionalArgs = new HashMap<String, Object>(serverArgs);
        requiredKeys.forEach(additionalArgs::remove);
        if (serverArgs.keySet().containsAll(requiredKeys)) {
            return this.newServer(serverArgs.get(KEY_ATX_NAME).toString(), serverArgs.get(KEY_TOOL_NAME).toString(), serverArgs.get(KEY_SERVER_URL).toString(), additionalArgs);
        }
        return this.newServer(serverArgs.get(KEY_ATX_NAME).toString(), serverArgs.get(KEY_TOOL_NAME).toString(), additionalArgs);
    }

    private ATXServer newServer(String atxName, String toolName, String fullServerUrl, Map<String, Object> additionalSettings) throws MalformedURLException {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put(KEY_ATX_NAME, atxName);
        stepVariables.put(KEY_TOOL_NAME, toolName);
        URL url = new URL(fullServerUrl);
        String protocol = url.getProtocol();
        boolean useHttpsConnection = "https".equals(protocol);
        String port = String.valueOf(url.getPort());
        String host = url.getHost();
        String path = url.getPath().replaceFirst("/", "");
        ATXConfig config = new ATXConfig();
        config.setSettingValueByName("serverURL", host);
        config.setSettingValueByName("serverPort", port);
        config.setSettingValueByName("serverContextPath", path);
        config.setSettingValueByName("useHttpsConnection", useHttpsConnection);
        additionalSettings.forEach(config::setSettingValueByName);
        stepVariables.put(KEY_CONFIG, config);
        ATXServer server = (ATXServer)this.script.invokeMethod("newATXServer", (Object)stepVariables);
        server.setScript(this.script);
        return server;
    }

    private ATXServer newServer(String atxName, String toolName, Map<String, Object> serverArgs) {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put(KEY_ATX_NAME, atxName);
        stepVariables.put(KEY_TOOL_NAME, toolName);
        ATXConfig config = new ATXConfig();
        serverArgs.forEach(config::setSettingValueByName);
        stepVariables.put(KEY_CONFIG, config);
        ATXServer server = (ATXServer)this.script.invokeMethod("newATXServer", (Object)stepVariables);
        server.setScript(this.script);
        return server;
    }
}

