/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.atx.pipeline;

import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXConfig;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXInstallation;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.pipeline.ATXServer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import java.util.Collections;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class ATXNewServerStep
extends Step {
    @Nonnull
    private final String atxName;
    @Nonnull
    private final String toolName;
    @CheckForNull
    private final ATXConfig config;

    @DataBoundConstructor
    public ATXNewServerStep(@Nonnull String atxName, @Nonnull String toolName, ATXConfig config) {
        this.atxName = atxName;
        this.toolName = toolName;
        this.config = config != null ? config : new ATXConfig();
    }

    @Nonnull
    public String getAtxName() {
        return this.atxName;
    }

    @Nonnull
    public String getToolName() {
        return this.toolName;
    }

    @CheckForNull
    public ATXConfig getConfig() {
        return this.config;
    }

    public StepExecution start(StepContext context) {
        return new Execution(this, context);
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "newATXServer";
        }

        public String getDisplayName() {
            return "Return new TEST-GUIDE server";
        }

        public boolean isAdvanced() {
            return true;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.emptySet();
        }
    }

    private static class Execution
    extends SynchronousStepExecution<ATXServer> {
        private static final long serialVersionUID = 1L;
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
        private final transient ATXNewServerStep step;

        Execution(ATXNewServerStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        protected ATXServer run() {
            ATXInstallation installation = new ATXInstallation(this.step.atxName, this.step.toolName, this.step.config);
            return new ATXServer(installation);
        }
    }
}

