/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.atx.pipeline;

import com.google.common.collect.ImmutableSet;
import de.tracetronic.jenkins.plugins.ecutest.ETPluginException;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXInstallation;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.pipeline.ATXServer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.TaskListener;
import java.util.Set;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class ATXGetServerStep
extends Step {
    @Nonnull
    private final String atxName;

    @DataBoundConstructor
    public ATXGetServerStep(@Nonnull String atxName) {
        this.atxName = atxName;
    }

    @Nonnull
    public String getAtxName() {
        return this.atxName;
    }

    public StepExecution start(StepContext context) {
        return new Execution(this, context);
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "getATXServer";
        }

        public String getDisplayName() {
            return "Get TEST-GUIDE server by name";
        }

        public boolean isAdvanced() {
            return true;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class);
        }
    }

    private static class Execution
    extends SynchronousStepExecution<ATXServer> {
        private static final long serialVersionUID = 1L;
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
        private final transient ATXGetServerStep step;

        Execution(ATXGetServerStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        protected ATXServer run() throws Exception {
            ATXInstallation installation = ATXInstallation.get(this.step.atxName);
            if (installation == null) {
                TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
                String message = String.format("TEST-GUIDE installation with name '%s' is not configured!", this.step.atxName);
                throw new ETPluginException(message, listener);
            }
            return new ATXServer(ATXInstallation.get(this.step.atxName));
        }
    }
}

