/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.atx.installation;

import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXBooleanSetting;
import hudson.model.AbstractDescribableImpl;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jvnet.localizer.LocaleProvider;

public abstract class ATXSetting<T>
extends AbstractDescribableImpl<ATXSetting<?>>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ATXSetting.class.getName());
    protected T value;
    private final String name;
    private final SettingsGroup group;
    @Deprecated
    private transient T currentValue;
    private transient String descGerman;
    private transient String descEnglish;
    private transient T defaultValue;

    public ATXSetting(String name, SettingsGroup group, T value) {
        this.name = name;
        this.group = group;
        this.value = value;
    }

    public ATXSetting(String name, SettingsGroup group, String descGerman, String descEnglish, T defaultValue) {
        this.name = name;
        this.group = group;
        this.descGerman = descGerman;
        this.descEnglish = descEnglish;
        this.defaultValue = defaultValue;
        this.value = defaultValue;
    }

    protected Object readResolve() {
        if (this.currentValue != null) {
            this.value = this.currentValue;
        }
        return this;
    }

    public ATXSetting<T> clone() {
        ATXSetting clone = null;
        try {
            clone = (ATXSetting)super.clone();
        }
        catch (CloneNotSupportedException e) {
            LOGGER.log(Level.SEVERE, "Could not clone ATXSetting!", e);
        }
        return clone;
    }

    @Whitelisted
    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return ATXSetting.toSpaceCase(this.name);
    }

    public SettingsGroup getGroup() {
        return this.group;
    }

    public String getDescGerman() {
        return this.descGerman;
    }

    public String getDescEnglish() {
        return this.descEnglish;
    }

    public String getDescription() {
        String locale = LocaleProvider.getLocale().getLanguage();
        String description = locale.equals(new Locale("de").getLanguage()) ? this.getDescGerman() : this.getDescEnglish();
        return description;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Whitelisted
    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public boolean isCheckbox() {
        return this instanceof ATXBooleanSetting;
    }

    public static String toString(boolean value) {
        return value ? "True" : "False";
    }

    private static String toSpaceCase(String camelCase) {
        String separated = camelCase.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), " ");
        return Character.toString(separated.charAt(0)).toUpperCase(Locale.getDefault()) + separated.substring(1);
    }

    public static enum SettingsGroup {
        CONNECTION("connectionConfig"),
        UPLOAD("uploadConfig"),
        ARCHIVE("archiveConfig"),
        ATTRIBUTE("attributeConfig"),
        TBC_CONSTANTS("tbcConstantConfig"),
        TCF_CONSTANTS("tcfConstantConfig"),
        REVIEW("reviewConfig"),
        SPECIAL("specialConfig");

        private final String configName;

        private SettingsGroup(String configName) {
            this.configName = configName;
        }

        public String getConfigName() {
            return this.configName;
        }

        public static SettingsGroup fromString(String configName) throws IllegalArgumentException {
            return Arrays.stream(SettingsGroup.values()).filter(v -> v.configName.equals(configName)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown settings group for: " + configName));
        }
    }
}

