/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.atx.installation;

import com.thoughtworks.xstream.XStream;
import de.tracetronic.jenkins.plugins.ecutest.ETPlugin;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.ATXPublisher;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXBooleanSetting;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXConfig;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXCustomSetting;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXSetting;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXTextSetting;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.Messages;
import de.tracetronic.jenkins.plugins.ecutest.tool.installation.ETInstallation;
import de.tracetronic.jenkins.plugins.ecutest.util.validation.ATXValidator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.XmlFile;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Saveable;
import hudson.model.listeners.SaveableListener;
import hudson.tools.ToolInstallation;
import hudson.util.FormValidation;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class ATXInstallation
extends AbstractDescribableImpl<ATXInstallation>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String toolName;
    private final ATXConfig config;

    @DataBoundConstructor
    public ATXInstallation(String name, String toolName, ATXConfig config) {
        this.name = StringUtils.trimToEmpty((String)name);
        this.toolName = toolName;
        this.config = config == null ? new ATXConfig() : config;
    }

    public static ATXInstallation[] all() {
        Jenkins instance = Jenkins.getInstanceOrNull();
        if (instance == null) {
            return new ATXInstallation[0];
        }
        DescriptorImpl atxDescriptor = (DescriptorImpl)instance.getDescriptorByType(DescriptorImpl.class);
        return atxDescriptor.getInstallations();
    }

    @CheckForNull
    public static ATXInstallation get(String name) {
        ATXInstallation[] installations;
        for (ATXInstallation installation : installations = ATXInstallation.all()) {
            if (!StringUtils.equals((String)name, (String)installation.getName())) continue;
            return installation;
        }
        return null;
    }

    @Whitelisted
    public String getName() {
        return this.name;
    }

    @Whitelisted
    public String getToolName() {
        return this.toolName;
    }

    public ATXConfig getConfig() {
        return this.config;
    }

    @Symbol(value={"testGuide"})
    @Extension(ordinal=1001.0)
    public static class DescriptorImpl
    extends Descriptor<ATXInstallation> {
        private static final Logger LOGGER = Logger.getLogger(DescriptorImpl.class.getName());
        private final transient ATXValidator atxValidator = new ATXValidator();
        private final transient ATXConfig defaultConfig = new ATXConfig();
        @SuppressFBWarnings(value={"VO_VOLATILE_REFERENCE_TO_ARRAY"})
        private volatile ATXInstallation[] installations = new ATXInstallation[0];

        public DescriptorImpl() {
            this.load();
        }

        public static String getATXConfigVersion() {
            return ETPlugin.ATX_CONFIG_VERSION.toMicroString();
        }

        public synchronized void load() {
            if (this.getConfigFile().exists()) {
                super.load();
            } else {
                this.migrateFromOldConfigFile(ATXPublisher.DescriptorImpl.class);
                this.save();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void migrateFromOldConfigFile(Class<ATXPublisher.DescriptorImpl> oldClass) {
            LOGGER.log(Level.FINE, "Migrating ATX installations from: " + oldClass.getName());
            XStream2 stream = new XStream2();
            stream.addCompatibilityAlias(oldClass.getName(), ((Object)((Object)this)).getClass());
            XmlFile file = new XmlFile((XStream)stream, new File(Jenkins.getInstance().getRootDir(), oldClass.getEnclosingClass().getName() + ".xml"));
            if (file.exists()) {
                try {
                    file.unmarshal((Object)this);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to migrate ATX installations from: " + file, e);
                }
                finally {
                    file.delete();
                }
            }
        }

        public ATXInstallation[] getInstallations() {
            return (ATXInstallation[])this.installations.clone();
        }

        public void setInstallations(ATXInstallation ... installations) {
            ArrayList inst = new ArrayList();
            if (installations != null) {
                Collections.addAll(inst, installations);
                for (ATXInstallation installation : installations) {
                    if (!StringUtils.isBlank((String)installation.getName())) continue;
                    inst.remove(installation);
                }
            }
            this.installations = inst.toArray(new ATXInstallation[0]);
        }

        public ATXConfig getDefaultConfig() {
            return this.defaultConfig;
        }

        public boolean configure(StaplerRequest req, JSONObject json) {
            ArrayList<ATXInstallation> list = new ArrayList<ATXInstallation>();
            JSONArray instArray = new JSONArray();
            JSONArray inst = json.optJSONArray("installation");
            if (inst == null) {
                instArray.add((Object)json.getJSONObject("installation"));
            } else {
                instArray.addAll((Collection)inst);
            }
            for (Object instObject : instArray) {
                if (!(instObject instanceof JSONObject)) continue;
                JSONObject instJson = (JSONObject)instObject;
                String name = instJson.getString("name");
                String toolName = instJson.getString("toolName");
                ATXConfig defaultConfig = this.getDefaultConfig().clone();
                List<ATXSetting<?>> settings = defaultConfig.getSettings();
                ArrayList<ATXCustomSetting> customSettings = req.bindJSONToList(ATXCustomSetting.class, instJson.get("customSettings"));
                customSettings.removeIf(atxCustomSetting -> this.getDefaultConfig().getSettingByName(atxCustomSetting.getName()).isPresent());
                customSettings = new ArrayList<ATXCustomSetting>(new LinkedHashSet(customSettings));
                ATXConfig config = new ATXConfig(this.updateCurrentValues(instJson, settings), customSettings);
                ATXInstallation installation = new ATXInstallation(name, toolName, config);
                list.add(installation);
            }
            this.setInstallations(list.toArray(new ATXInstallation[0]));
            this.save();
            return true;
        }

        public void syncWithDefaultConfig() {
            ArrayList<ATXInstallation> list = new ArrayList<ATXInstallation>();
            for (ATXInstallation installation : (ATXInstallation[])this.installations.clone()) {
                ATXConfig currentConfig = installation.getConfig();
                ATXConfig newConfig = this.defaultConfig.clone();
                if (currentConfig != null) {
                    for (ATXSetting<?> newSetting : newConfig.getSettings()) {
                        Optional<ATXSetting<?>> currentSetting = currentConfig.getSettingByName(newSetting.getName());
                        currentSetting.ifPresent(atxSetting -> newConfig.setSettingValueByName(atxSetting.getName(), atxSetting.getValue()));
                    }
                    ArrayList customSettings = currentConfig.getCustomSettings();
                    newConfig.setCustomSettings(customSettings == null ? new ArrayList() : customSettings);
                }
                ATXInstallation inst = new ATXInstallation(installation.getName(), installation.getToolName(), newConfig);
                list.add(inst);
            }
            this.setInstallations(list.toArray(new ATXInstallation[0]));
        }

        private List<ATXSetting<?>> updateCurrentValues(JSONObject installation, List<ATXSetting<?>> settings) {
            for (ATXSetting<?> setting : settings) {
                JSONObject settingsGroup = installation.optJSONObject(setting.getGroup().getConfigName());
                if (settingsGroup == null) continue;
                Object currentSetting = settingsGroup.opt(setting.getName());
                if (currentSetting instanceof String) {
                    ((ATXTextSetting)setting).setValue((String)currentSetting);
                    continue;
                }
                if (!(currentSetting instanceof Boolean)) continue;
                ((ATXBooleanSetting)setting).setValue((Boolean)currentSetting);
            }
            return settings;
        }

        public List<ATXCustomSetting> getCustomSettings(ATXInstallation installation) {
            return installation == null ? new ArrayList() : installation.getConfig().getCustomSettings();
        }

        public List<Descriptor<? extends ATXCustomSetting>> getApplicableCustomSettings() {
            return new ArrayList<Descriptor<? extends ATXCustomSetting>>((Collection<Descriptor<? extends ATXCustomSetting>>)ATXCustomSetting.all());
        }

        public ETInstallation.DescriptorImpl getToolDescriptor() {
            return (ETInstallation.DescriptorImpl)((Object)ToolInstallation.all().get(ETInstallation.DescriptorImpl.class));
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.ATXInstallation_DisplayName();
        }

        public FormValidation doCheckName(@QueryParameter String value) {
            return this.atxValidator.validateName(value);
        }

        public FormValidation doCheckSetting(@QueryParameter String name, @QueryParameter String value) {
            return this.atxValidator.validateSetting(name, value);
        }

        @RequirePOST
        public FormValidation doTestConnection(@QueryParameter String serverURL, @QueryParameter String serverPort, @QueryParameter String serverContextPath, @QueryParameter boolean useHttpsConnection, @QueryParameter String httpProxy, @QueryParameter String httpsProxy, @QueryParameter boolean ignoreSSL) {
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            String proxyUrl = useHttpsConnection ? httpsProxy : httpProxy;
            return this.atxValidator.testConnection(serverURL, serverPort, serverContextPath, useHttpsConnection, proxyUrl, ignoreSSL);
        }
    }

    @Extension
    public static class SaveableListenerImpl
    extends SaveableListener {
        public final void onChange(Saveable o, XmlFile file) {
            if (o instanceof DescriptorImpl) {
                ((DescriptorImpl)o).syncWithDefaultConfig();
            }
            super.onChange(o, file);
        }
    }
}

