/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.atx.installation;

import de.tracetronic.jenkins.plugins.ecutest.report.atx.ATXPublisher;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXBooleanSetting;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXCustomSetting;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXSetting;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXSettingParser;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXTextSetting;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.Messages;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ATXConfig
extends AbstractDescribableImpl<ATXConfig>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ATXPublisher.class.getName());
    private List<ATXSetting<?>> settings;
    private List<ATXCustomSetting> customSettings;
    @Deprecated
    private transient Map<String, List<ATXSetting<?>>> configMap;

    public ATXConfig() {
        this.settings = this.parseDefaultConfig();
        this.customSettings = new ArrayList<ATXCustomSetting>();
    }

    @DataBoundConstructor
    public ATXConfig(List<ATXSetting<?>> settings, List<ATXCustomSetting> customSettings) {
        this.settings = settings == null ? this.parseDefaultConfig() : settings;
        this.customSettings = customSettings == null ? new ArrayList() : customSettings;
    }

    protected Object readResolve() {
        if (this.configMap != null) {
            this.settings = new ArrayList();
            for (Map.Entry<String, List<ATXSetting<?>>> config : this.configMap.entrySet()) {
                String groupName = config.getKey();
                ATXSetting.SettingsGroup settingsGroup = ATXConfig.getSettingsGroup(groupName);
                for (ATXSetting<?> setting : config.getValue()) {
                    ATXSetting newSetting;
                    String settingName = setting.getName();
                    String descGerman = setting.getDescGerman();
                    String descEnglish = setting.getDescEnglish();
                    if (setting.isCheckbox()) {
                        newSetting = new ATXBooleanSetting(settingName, settingsGroup, descGerman, descEnglish, (Boolean)setting.getDefaultValue());
                        newSetting.setValue(((ATXBooleanSetting)setting).getValue());
                        this.settings.add(newSetting);
                        continue;
                    }
                    newSetting = new ATXTextSetting(settingName, settingsGroup, descGerman, descEnglish, (String)setting.getDefaultValue());
                    newSetting.setValue(((ATXTextSetting)setting).getValue());
                    this.settings.add(newSetting);
                }
            }
        }
        return this;
    }

    public ATXConfig clone() {
        ATXConfig clone = null;
        try {
            ATXConfig configClone = (ATXConfig)super.clone();
            ArrayList settings = new ArrayList();
            for (ATXSetting<?> setting : configClone.getSettings()) {
                settings.add((ATXSetting<?>)setting.clone());
            }
            ArrayList<ATXCustomSetting> customSettings = new ArrayList<ATXCustomSetting>();
            for (ATXCustomSetting setting : configClone.getCustomSettings()) {
                customSettings.add(setting.clone());
            }
            clone = new ATXConfig(settings, customSettings);
        }
        catch (CloneNotSupportedException e) {
            LOGGER.log(Level.SEVERE, "Could not clone ATXConfig!", e);
        }
        return clone;
    }

    public List<ATXSetting<?>> getSettings() {
        return this.settings;
    }

    public void setSettings(List<ATXSetting<?>> settings) {
        this.settings = settings;
    }

    public List<ATXCustomSetting> getCustomSettings() {
        return this.customSettings;
    }

    public void setCustomSettings(List<ATXCustomSetting> customSettings) {
        this.customSettings = customSettings;
    }

    private List<ATXSetting<?>> parseDefaultConfig() {
        Document doc = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try (InputStream configFile = ATXConfig.class.getResourceAsStream("config.xml");){
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(configFile);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOGGER.log(Level.SEVERE, "Error parsing ATX template configuration: " + e.getMessage(), e);
        }
        return ATXSettingParser.parseSettings(doc);
    }

    public Optional<ATXSetting<?>> getSettingByName(String name) {
        return this.settings.stream().filter(setting -> setting.getName().equals(name)).findFirst();
    }

    public List<ATXSetting<?>> getSettingsByGroup(ATXSetting.SettingsGroup group) {
        return this.settings.stream().filter(setting -> setting.getGroup().equals((Object)group)).collect(Collectors.toList());
    }

    public List<ATXSetting<?>> getSettingsByGroupName(String groupName) {
        ATXSetting.SettingsGroup group = ATXConfig.getSettingsGroup(groupName);
        return this.getSettingsByGroup(group);
    }

    public Object getSettingValueByName(String name) throws IllegalArgumentException {
        return this.getSettingByName(name).map(ATXSetting::getValue).orElseThrow(() -> new IllegalArgumentException("No setting found with name: " + name));
    }

    @CheckForNull
    public Object getSettingValueBySettings(String name, List<ATXSetting<?>> settings) {
        return settings.stream().filter(setting -> setting.getName().equals(name)).findFirst().map(ATXSetting::getValue).orElse(null);
    }

    @CheckForNull
    public Object getSettingValueByGroup(String name, ATXSetting.SettingsGroup group) {
        List<ATXSetting<?>> settings = this.getSettingsByGroup(group);
        return this.getSettingValueBySettings(name, settings);
    }

    public void setSettingValueByName(String name, Object value) {
        this.getSettingByName(name).ifPresent(setting -> {
            if (setting instanceof ATXTextSetting) {
                ((ATXTextSetting)setting).setValue((String)value);
            } else if (setting instanceof ATXBooleanSetting) {
                ((ATXBooleanSetting)setting).setValue((Boolean)value);
            } else {
                throw new IllegalArgumentException("Only String and Boolean value types are supported!");
            }
        });
    }

    public static ATXSetting.SettingsGroup getSettingsGroup(String groupName) {
        return ATXSetting.SettingsGroup.fromString(groupName);
    }

    @Symbol(value={"atxConfig"})
    @Extension
    public static class DescriptorImpl
    extends Descriptor<ATXConfig> {
        @Nonnull
        public String getDisplayName() {
            return Messages.ATXConfig_DisplayName();
        }
    }
}

