/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.atx;

import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXBooleanSetting;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXConfig;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXCustomBooleanSetting;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXCustomSetting;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXCustomTextSetting;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXInstallation;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXSetting;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXTextSetting;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jenkins.security.MasterToSlaveCallable;

public abstract class AbstractATXReportHandler {
    protected static final String ATX_TEMPLATE_NAME = "ATX";
    private final ATXInstallation installation;

    public AbstractATXReportHandler(ATXInstallation installation) {
        this.installation = installation;
    }

    protected ATXInstallation getInstallation() {
        return this.installation;
    }

    protected static abstract class AbstractReportCallable<T>
    extends MasterToSlaveCallable<T, IOException> {
        private static final long serialVersionUID = 1L;
        private final ATXConfig config;
        private final List<FilePath> reportFiles;
        private final EnvVars envVars;
        private final TaskListener listener;

        public AbstractReportCallable(ATXConfig config, List<FilePath> reportFiles, EnvVars envVars, TaskListener listener) {
            this.config = config;
            this.reportFiles = reportFiles;
            this.envVars = envVars;
            this.listener = listener;
        }

        public List<FilePath> getReportFiles() {
            return this.reportFiles;
        }

        public TaskListener getListener() {
            return this.listener;
        }

        protected Map<String, String> getConfigMap(boolean uploadToServer, boolean injectBuildVars) {
            LinkedHashMap<String, String> configMap = new LinkedHashMap<String, String>();
            for (ATXSetting<?> aTXSetting : this.config.getSettings()) {
                if (aTXSetting instanceof ATXBooleanSetting) {
                    if ("uploadToServer".equals(aTXSetting.getName())) {
                        configMap.put(aTXSetting.getName(), ATXSetting.toString(uploadToServer));
                        continue;
                    }
                    configMap.put(aTXSetting.getName(), ATXSetting.toString((Boolean)((ATXBooleanSetting)aTXSetting).getValue()));
                    continue;
                }
                configMap.put(aTXSetting.getName(), this.envVars.expand((String)((ATXTextSetting)aTXSetting).getValue()));
            }
            for (ATXCustomSetting aTXCustomSetting : this.config.getCustomSettings()) {
                if (aTXCustomSetting instanceof ATXCustomBooleanSetting) {
                    configMap.put(aTXCustomSetting.getName(), ATXSetting.toString(((ATXCustomBooleanSetting)aTXCustomSetting).isChecked()));
                    continue;
                }
                if (!(aTXCustomSetting instanceof ATXCustomTextSetting)) continue;
                configMap.put(aTXCustomSetting.getName(), this.envVars.expand(((ATXCustomTextSetting)aTXCustomSetting).getValue()));
            }
            if (injectBuildVars) {
                List<String> constants = Arrays.asList((String)configMap.get("setConstants"), this.formatConstant("BUILD_NUMBER"), this.formatConstant("BUILD_URL"), this.formatConstant("JOB_NAME"));
                configMap.replace("setConstants", String.join((CharSequence)";", constants));
            }
            return configMap;
        }

        private String formatConstant(String variableName) {
            return String.format("%s=%s", "TT_JENKINS_" + variableName, this.envVars.get((Object)variableName));
        }
    }
}

