/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.atx;

import de.tracetronic.jenkins.plugins.ecutest.env.TestEnvInvisibleAction;
import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.report.AbstractReportPublisher;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.ATXBuildAction;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.ATXReport;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.AbstractATXReportHandler;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXConfig;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXInstallation;
import de.tracetronic.jenkins.plugins.ecutest.util.ATXUtil;
import de.tracetronic.jenkins.plugins.ecutest.util.validation.ATXValidator;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComClient;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComException;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComProperty;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.TestEnvironment;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import jenkins.security.MasterToSlaveCallable;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.groovy.JsonSlurper;

public class ATXReportUploader
extends AbstractATXReportHandler {
    private static final String ATX_TREND_URL = "wicket/bookmarkable/de.tracetronic.ttstm.web.detail.TestCaseDetailPage?testCase";

    public ATXReportUploader(ATXInstallation installation) {
        super(installation);
    }

    public boolean upload(List<FilePath> reportDirs, boolean usePersistedSettings, boolean injectBuildVars, boolean allowMissing, Run<?, ?> run, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        ArrayList<ATXReport> atxReports = new ArrayList<ATXReport>();
        EnvVars envVars = run.getEnvironment(listener);
        ATXConfig config = this.getInstallation().getConfig();
        String projectId = ATXUtil.getProjectId(config, envVars);
        String baseUrl = ATXUtil.getBaseUrl(config, envVars);
        if (baseUrl == null) {
            logger.logError(String.format("Error getting base URL for selected TEST-GUIDE installation: %s", this.getInstallation().getName()));
            return false;
        }
        this.checkForWarning(config, logger);
        for (FilePath reportDir : reportDirs) {
            FilePath reportFile = AbstractReportPublisher.getFirstReportFile(reportDir);
            if (reportFile != null && reportFile.exists()) {
                List<FilePath> uploadFiles = Arrays.asList(reportDir.list("**/*.trf", "*/**/Job_*.trf"));
                UploadInfoHolder uploadInfo = (UploadInfoHolder)launcher.getChannel().call((Callable)new UploadReportCallable(config, uploadFiles, usePersistedSettings, injectBuildVars, envVars, listener));
                if (!uploadInfo.isUploaded()) continue;
                String title = reportFile.getParent().getName();
                if (uploadInfo.getTestInfo() == null) {
                    uploadInfo.setTestInfo((TestInfoHolder)launcher.getChannel().call((Callable)new ParseTRFCallable(reportFile.getRemote())));
                }
                this.traverseReports(atxReports, reportDir, title, baseUrl, uploadInfo.getTestInfo(), projectId);
                continue;
            }
            if (allowMissing) continue;
            logger.logError(String.format("Specified TRF file '%s' does not exist.", reportFile));
            return false;
        }
        if (atxReports.isEmpty() && !allowMissing) {
            logger.logError("Empty test results are not allowed, setting build status to FAILURE!");
            return false;
        }
        this.addBuildAction(run, atxReports);
        return true;
    }

    private void checkForWarning(ATXConfig config, TTConsoleLogger logger) {
        if (((Boolean)config.getSettingValueByName("cleanAfterSuccessUpload")).booleanValue()) {
            logger.logWarn("-> In order to generate ATX report links with unique ATX identifiers disable the upload setting 'Clean After Success Upload' in the TEST-GUIDE configuration.");
        }
    }

    private void traverseReports(List<ATXReport> atxReports, FilePath testReportDir, String title, String baseUrl, TestInfoHolder testInfo, String projectId) throws IOException, InterruptedException {
        String reportUrl;
        String trendReportUrl = null;
        TestEnvInvisibleAction.TestType testType = testInfo.getTestType();
        if (testType == TestEnvInvisibleAction.TestType.PACKAGE) {
            reportUrl = this.getPkgReportUrl(baseUrl, testInfo, projectId);
            trendReportUrl = this.getPkgTrendReportUrl(baseUrl, testInfo, projectId);
        } else {
            reportUrl = this.getPrjReportUrl(baseUrl, testInfo, null, projectId);
        }
        ATXReport atxReport = new ATXReport(AbstractReportPublisher.randomId(), title, reportUrl);
        if (trendReportUrl != null) {
            atxReport.addSubReport(new ATXReport(AbstractReportPublisher.randomId(), title, trendReportUrl, true));
        }
        atxReports.add(atxReport);
        boolean isSingleTestplanMap = ATXUtil.isSingleTestplanMap(this.getInstallation().getConfig());
        if (isSingleTestplanMap) {
            this.traverseSubReports(atxReport, testReportDir, baseUrl, testInfo, null, projectId);
        } else {
            this.traverseSubReports(atxReport, testReportDir, baseUrl, testInfo, testInfo.getTestName(), projectId);
        }
    }

    private void traverseSubReports(ATXReport atxReport, FilePath testReportDir, String baseUrl, TestInfoHolder testInfo, String projectName, String projectId) throws IOException, InterruptedException {
        for (FilePath subDir : testReportDir.listDirectories()) {
            FilePath reportFile = AbstractReportPublisher.getFirstReportFile(subDir);
            if (reportFile == null || !reportFile.exists()) continue;
            String testName = "report.trf".equals(reportFile.getName()) ? reportFile.getParent().getName().replaceFirst("^Report\\s", "") : reportFile.getBaseName();
            String subTestName = ATXUtil.getValidATXName(testName);
            String reportUrl = this.getPrjSubReportUrl(baseUrl, testInfo, subTestName, projectName, projectId);
            ATXReport subReport = new ATXReport(AbstractReportPublisher.randomId(), testName, reportUrl);
            atxReport.addSubReport(subReport);
            this.traverseSubReports(subReport, subDir, baseUrl, testInfo, projectName, projectId);
        }
    }

    private void addBuildAction(Run<?, ?> run, List<ATXReport> atxReports) {
        ATXBuildAction<ATXReport> action = (ATXBuildAction<ATXReport>)run.getAction(ATXBuildAction.class);
        if (action == null) {
            action = new ATXBuildAction<ATXReport>(false);
            run.addAction(action);
        }
        action.addAll(atxReports);
    }

    private String getPkgTrendReportUrl(String baseUrl, TestInfoHolder testInfo, String projectId) {
        String testName = ATXUtil.getValidATXName(testInfo.getTestName());
        String pkgTrendReportUrl = String.format("%s/%s=%s", baseUrl, ATX_TREND_URL, testName);
        if (projectId != null) {
            pkgTrendReportUrl = String.format("%s&projectId=%s", pkgTrendReportUrl, projectId);
        }
        return pkgTrendReportUrl;
    }

    private String getPkgReportUrl(String baseUrl, TestInfoHolder testInfo, String projectId) {
        if (testInfo.getLink() != null) {
            return testInfo.getLink();
        }
        String testName = testInfo.getTestName();
        String from = String.valueOf(testInfo.getFrom());
        String to = String.valueOf(testInfo.getTo());
        String atxTestName = ATXUtil.getValidATXName(testName);
        String pkgReportUrl = String.format("%s/reports?dateFrom=%s&dateTo=%s&testcase=%s", baseUrl, from, to, atxTestName);
        if (projectId != null) {
            pkgReportUrl = String.format("%s&projectId=%s", pkgReportUrl, projectId);
        }
        return pkgReportUrl;
    }

    private String getPrjReportUrl(String baseUrl, TestInfoHolder testInfo, String projectName, String projectId) {
        if (testInfo.getLink() != null) {
            return testInfo.getLink();
        }
        String testName = ATXUtil.getValidATXName(testInfo.getTestName());
        String from = String.valueOf(testInfo.getFrom());
        String to = String.valueOf(testInfo.getTo());
        String prjReportUrl = projectName != null ? String.format("%s/reports?dateFrom=%s&dateTo=%s&testexecplan=%s&plannedTestCaseFolder=%s*", baseUrl, from, to, projectName, testName) : String.format("%s/reports?dateFrom=%s&dateTo=%s&testexecplan=%s", baseUrl, from, to, testName);
        if (projectId != null) {
            prjReportUrl = String.format("%s&projectId=%s", prjReportUrl, projectId);
        }
        return prjReportUrl;
    }

    private String getPrjSubReportUrl(String baseUrl, TestInfoHolder testInfo, String subTestName, String projectName, String projectId) {
        String from = String.valueOf(testInfo.getFrom());
        String to = String.valueOf(testInfo.getTo());
        String prjReportUrl = projectName != null ? String.format("%s/reports?dateFrom=%s&dateTo=%s&testexecplan=%s&plannedTestCaseFolder=%s*", baseUrl, from, to, ATXUtil.getValidATXName(projectName), subTestName) : String.format("%s/reports?dateFrom=%s&dateTo=%s&testexecplan=%s", baseUrl, from, to, subTestName);
        if (projectId != null) {
            prjReportUrl = String.format("%s&projectId=%s", prjReportUrl, projectId);
        }
        return prjReportUrl;
    }

    private static final class TestInfoHolder
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String testName;
        private final TestEnvInvisibleAction.TestType testType;
        private final long from;
        private final long to;
        private String link;

        TestInfoHolder(String testName, TestEnvInvisibleAction.TestType testType, long from, long to) {
            this.testName = testName;
            this.testType = testType;
            this.from = from;
            this.to = to;
            this.setLink(null);
        }

        public String getTestName() {
            return this.testName;
        }

        public TestEnvInvisibleAction.TestType getTestType() {
            return this.testType;
        }

        public long getFrom() {
            return this.from;
        }

        public long getTo() {
            return this.to;
        }

        public String getLink() {
            return this.link;
        }

        public void setLink(String link) {
            this.link = link;
        }
    }

    private static final class UploadInfoHolder
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private boolean uploaded;
        private TestInfoHolder testInfo;

        UploadInfoHolder(boolean uploaded) {
            this.uploaded = uploaded;
        }

        public boolean isUploaded() {
            return this.uploaded;
        }

        public void setUploaded(boolean uploaded) {
            this.uploaded = uploaded;
        }

        public TestInfoHolder getTestInfo() {
            return this.testInfo;
        }

        public void setTestInfo(TestInfoHolder testInfo) {
            this.testInfo = testInfo;
        }
    }

    private static final class ParseTRFCallable
    extends MasterToSlaveCallable<TestInfoHolder, IOException> {
        private static final long serialVersionUID = 1L;
        private static final String QUERY_INFO = "SELECT execution_time, duration from info";
        private static final String QUERY_PRJ = "SELECT name FROM prj";
        private static final String QUERY_PKG = "SELECT name FROM pkg";
        private final String trfFile;

        ParseTRFCallable(String trfFile) {
            this.trfFile = trfFile;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public TestInfoHolder call() throws IOException {
            try (SQLite sql = new SQLite(this.trfFile);){
                ResultSet rs = sql.query(QUERY_INFO);
                String execTime = rs.getString("execution_time");
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date date = fmt.parse(execTime);
                float duration = rs.getFloat("duration") * 1000.0f;
                long from = date.getTime();
                long to = from + (long)duration;
                rs = sql.query(QUERY_PRJ);
                String prjName = rs.getString("name");
                if ("$$$_PACKAGE_$$$".equals(prjName)) {
                    rs = sql.query(QUERY_PKG);
                    String pkgName = rs.getString("name");
                    TestInfoHolder testInfoHolder = new TestInfoHolder(pkgName, TestEnvInvisibleAction.TestType.PACKAGE, from, to);
                    return testInfoHolder;
                }
                TestInfoHolder testInfoHolder = new TestInfoHolder(prjName, TestEnvInvisibleAction.TestType.PROJECT, from, to);
                return testInfoHolder;
            }
            catch (ClassNotFoundException | SQLException | ParseException e) {
                throw new IOException(e);
            }
        }

        private static class SQLite
        implements AutoCloseable {
            private final Connection connection;
            private PreparedStatement statement;

            SQLite(String sqlFile) throws ClassNotFoundException, SQLException {
                Class.forName("org.sqlite.JDBC");
                this.connection = DriverManager.getConnection("jdbc:sqlite:" + sqlFile);
            }

            @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="Constant query statements used only")
            public ResultSet query(String sql) throws SQLException {
                this.statement = this.connection.prepareStatement(sql);
                return this.statement.executeQuery();
            }

            @Override
            public void close() throws SQLException {
                if (this.statement != null) {
                    this.statement.close();
                }
                if (this.connection != null) {
                    this.connection.close();
                }
            }
        }
    }

    private static final class UploadReportCallable
    extends AbstractATXReportHandler.AbstractReportCallable<UploadInfoHolder> {
        private static final long serialVersionUID = 1L;
        private static final String ERROR_FILE_NAME = "error.raw.json";
        private static final String SUCCESS_FILE_NAME = "success.json";
        private final boolean usePersistedSettings;
        private final boolean injectBuildVars;

        UploadReportCallable(ATXConfig config, List<FilePath> reportFiles, boolean usePersistedSettings, boolean injectBuildVars, EnvVars envVars, TaskListener listener) {
            super(config, reportFiles, envVars, listener);
            this.usePersistedSettings = usePersistedSettings;
            this.injectBuildVars = injectBuildVars;
        }

        public UploadInfoHolder call() throws IOException {
            UploadInfoHolder uploadInfo = new UploadInfoHolder(false);
            TTConsoleLogger logger = new TTConsoleLogger(this.getListener());
            Map<String, String> configMap = this.getConfigMap(true, this.injectBuildVars);
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);){
                TestEnvironment testEnv = (TestEnvironment)comClient.getTestEnvironment();
                List<FilePath> reportFiles = this.getReportFiles();
                if (reportFiles.isEmpty()) {
                    logger.logInfo("-> No report files found to upload!");
                } else {
                    for (FilePath reportFile : reportFiles) {
                        logger.logInfo(String.format("-> Generating and uploading ATX report: %s", reportFile.getRemote()));
                        FilePath outDir = reportFile.getParent().child("ATX");
                        if (this.usePersistedSettings) {
                            FilePath reportDir = reportFile.getParent();
                            FilePath configPath = reportDir.child("ATX.xml");
                            logger.logInfo(String.format("- Using persisted settings from configuration: %s", configPath.getRemote()));
                            testEnv.generateTestReportDocument(reportFile.getRemote(), reportDir.getRemote(), configPath.getRemote(), true);
                        } else {
                            testEnv.generateTestReportDocumentFromDB(reportFile.getRemote(), outDir.getRemote(), "ATX", true, configMap);
                        }
                        comClient.waitForIdle(0);
                        FilePath errorFile = outDir.child(ERROR_FILE_NAME);
                        if (!this.checkErrorLog(errorFile, logger)) continue;
                        FilePath successFile = outDir.child(SUCCESS_FILE_NAME);
                        boolean uploadAsync = configMap.get("uploadAsync").equals("True");
                        uploadInfo.setTestInfo(this.checkSuccessLog(successFile, reportFile, uploadAsync, logger));
                        uploadInfo.setUploaded(true);
                    }
                }
            }
            catch (ETComException e) {
                logger.logComException(e);
            }
            return uploadInfo;
        }

        private TestInfoHolder checkSuccessLog(FilePath successFile, FilePath uploadFile, boolean uploadAsync, TTConsoleLogger logger) throws IOException {
            TestInfoHolder testInfo;
            block4: {
                testInfo = null;
                try {
                    if (!successFile.exists()) break block4;
                    logger.logDebug("ATX report uploaded successfully.");
                    String content = successFile.readToString();
                    logger.logDebug(String.format("Response: %s", content));
                    JSONObject jsonObject = (JSONObject)new JsonSlurper().parseText(content);
                    JSONArray jsonArray = jsonObject.optJSONArray(uploadAsync ? "messages" : "ENTRIES");
                    if (jsonArray == null) break block4;
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        String status = jsonArray.getJSONObject(i).getString(uploadAsync ? "statusCode" : "STATUS");
                        if (!"200".equals(status)) continue;
                        String text = jsonArray.getJSONObject(i).getString(uploadAsync ? "body" : "TEXT");
                        URL location = this.resolveRedirect(text);
                        testInfo = this.parseTestInfo(location, uploadFile);
                        if (testInfo != null) {
                            testInfo.setLink(text);
                        }
                        break;
                    }
                }
                catch (UnsupportedEncodingException | InterruptedException | MalformedURLException | KeyManagementException | NoSuchAlgorithmException | JSONException e) {
                    logger.logError("-> Could not parse ATX JSON response: " + e.getMessage());
                }
            }
            return testInfo;
        }

        private boolean checkErrorLog(FilePath errorFile, TTConsoleLogger logger) throws IOException {
            boolean hasNoErrors = true;
            try {
                if (errorFile.exists()) {
                    hasNoErrors = false;
                    logger.logError("Error while uploading ATX report!");
                    String content = errorFile.readToString();
                    logger.logDebug(String.format("Response: %s", content));
                    JSONObject jsonObject = (JSONObject)new JsonSlurper().parseText(content);
                    JSONArray jsonArray = jsonObject.optJSONArray("ENTRIES");
                    if (jsonArray != null) {
                        for (int i = 0; i < jsonArray.size(); ++i) {
                            String file = jsonArray.getJSONObject(i).getString("FILE");
                            String status = jsonArray.getJSONObject(i).getString("STATUS");
                            String text = jsonArray.getJSONObject(i).getString("TEXT");
                            logger.logError(String.format("%s: %s - %s", status, file, text));
                        }
                    }
                }
            }
            catch (InterruptedException | JSONException e) {
                logger.logError("-> Could not parse ATX JSON response: " + e.getMessage());
                hasNoErrors = false;
            }
            return hasNoErrors;
        }

        private TestInfoHolder parseTestInfo(URL url, FilePath uploadFile) throws UnsupportedEncodingException {
            Map<String, String> params = this.splitQuery(url);
            if (params.isEmpty()) {
                return null;
            }
            String testName = params.get("testexecplan");
            TestEnvInvisibleAction.TestType testType = TestEnvInvisibleAction.TestType.PROJECT;
            if ("SinglePackageExecution".equals(testName)) {
                testType = TestEnvInvisibleAction.TestType.PACKAGE;
                testName = uploadFile.getBaseName();
            }
            long from = Long.parseLong(params.get("dateFrom"));
            long to = Long.parseLong(params.get("dateTo"));
            return new TestInfoHolder(testName, testType, from, to);
        }

        private Map<String, String> splitQuery(URL url) throws UnsupportedEncodingException {
            String[] pairs;
            LinkedHashMap<String, String> queryMap = new LinkedHashMap<String, String>();
            String query = url.getQuery();
            for (String pair : pairs = query.split("&")) {
                int idx = pair.indexOf(61);
                queryMap.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
            }
            return queryMap;
        }

        private URL resolveRedirect(String redirect) throws MalformedURLException, NoSuchAlgorithmException, KeyManagementException, IOException {
            HttpURLConnection connection;
            URL url = new URL(redirect);
            if (redirect.startsWith("https://")) {
                connection = (HttpsURLConnection)url.openConnection();
                ATXValidator.ignoreSSLIssues((HttpsURLConnection)connection);
            } else {
                connection = (HttpURLConnection)url.openConnection();
            }
            connection.setInstanceFollowRedirects(false);
            connection.connect();
            String location = connection.getHeaderField("Location");
            return new URL(location);
        }
    }
}

