/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.atx;

import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.report.AbstractReportPublisher;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.ATXBuildAction;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.ATXZipReport;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.AbstractATXReportHandler;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXConfig;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXInstallation;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComClient;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComException;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.ETComProperty;
import de.tracetronic.jenkins.plugins.ecutest.wrapper.com.TestEnvironment;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ATXReportGenerator
extends AbstractATXReportHandler {
    public ATXReportGenerator(ATXInstallation installation) {
        super(installation);
    }

    public boolean generate(FilePath archiveTarget, List<FilePath> reportDirs, boolean usePersistedSettings, boolean injectBuildVars, boolean allowMissing, boolean isArchiving, boolean keepAll, Run<?, ?> run, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        ArrayList<FilePath> reportFiles = new ArrayList<FilePath>();
        for (FilePath reportDir : reportDirs) {
            FilePath reportFile = AbstractReportPublisher.getFirstReportFile(reportDir);
            if (reportFile != null && reportFile.exists()) {
                reportFiles.addAll(Arrays.asList(reportDir.list("**/*.trf", "*/**/Job_*.trf")));
                continue;
            }
            if (allowMissing) continue;
            logger.logError(String.format("Specified TRF file '%s' does not exist.", reportFile));
            return false;
        }
        if (reportFiles.isEmpty() && !allowMissing) {
            logger.logError("Empty test results are not allowed, setting build status to FAILURE!");
            return false;
        }
        boolean isGenerated = (Boolean)launcher.getChannel().call((Callable)new GenerateReportCallable(this.getInstallation().getConfig(), reportFiles, usePersistedSettings, injectBuildVars, run.getEnvironment(listener), listener));
        if (isArchiving) {
            if (!reportFiles.isEmpty() && !keepAll) {
                archiveTarget.deleteRecursive();
                AbstractReportPublisher.removePreviousReports(run, ATXBuildAction.class);
            }
            if (isGenerated && !reportFiles.isEmpty()) {
                ArrayList<ATXZipReport> atxReports = new ArrayList<ATXZipReport>();
                logger.logInfo("- Archiving generated ATX reports...");
                for (FilePath reportDir : reportDirs) {
                    FilePath archiveTargetDir = archiveTarget.child(reportDir.getName());
                    try {
                        int copiedFiles = reportDir.copyRecursiveTo(String.format("**/%s/*.zip", "ATX"), archiveTargetDir);
                        logger.logInfo(String.format("-> Archived %d report(s).", copiedFiles));
                        if (copiedFiles == 0) {
                            continue;
                        }
                    }
                    catch (IOException e) {
                        Util.displayIOException((IOException)e, (TaskListener)listener);
                        logger.logError("Failed archiving generated ATX reports.");
                        return false;
                    }
                    this.traverseReports(atxReports, archiveTargetDir);
                }
                this.addBuildAction(run, atxReports, keepAll);
            }
        } else {
            logger.logInfo("Archiving ATX reports is disabled.");
        }
        return isGenerated;
    }

    private void traverseReports(List<ATXZipReport> atxReports, FilePath archiveTargetDir) throws IOException, InterruptedException {
        FilePath[] zipFiles = archiveTargetDir.list(String.format("%s/%s.zip", "ATX", archiveTargetDir.getName()));
        if (zipFiles.length == 1) {
            FilePath zipFile = zipFiles[0];
            String relFilePath = archiveTargetDir.getParent().toURI().relativize(zipFile.toURI()).getPath();
            ATXZipReport atxReport = new ATXZipReport(AbstractReportPublisher.randomId(), zipFile.getBaseName(), relFilePath, zipFile.length());
            atxReports.add(atxReport);
            this.traverseSubReports(atxReport, archiveTargetDir.getParent(), archiveTargetDir);
        }
    }

    private void traverseSubReports(ATXZipReport atxReport, FilePath testReportDir, FilePath subTestReportDir) throws IOException, InterruptedException {
        for (FilePath subDir : subTestReportDir.listDirectories()) {
            FilePath[] reportFiles = subDir.list(String.format("%s/%s.zip", "ATX", subDir.getName()));
            if (reportFiles.length != 1) continue;
            FilePath reportFile = reportFiles[0];
            String fileName = reportFile.getBaseName().replaceFirst("^Report\\s", "");
            String relFilePath = testReportDir.toURI().relativize(reportFile.toURI()).getPath();
            ATXZipReport subReport = new ATXZipReport(AbstractReportPublisher.randomId(), fileName, relFilePath, reportFile.length());
            atxReport.addSubReport(subReport);
            this.traverseSubReports(subReport, testReportDir, subDir);
        }
    }

    private void addBuildAction(Run<?, ?> run, List<ATXZipReport> atxReports, boolean keepAll) {
        ATXBuildAction<ATXZipReport> action = (ATXBuildAction<ATXZipReport>)run.getAction(ATXBuildAction.class);
        if (action == null) {
            action = new ATXBuildAction<ATXZipReport>(!keepAll);
            run.addAction(action);
        }
        action.addAll(atxReports);
    }

    private static final class GenerateReportCallable
    extends AbstractATXReportHandler.AbstractReportCallable<Boolean> {
        private static final long serialVersionUID = 1L;
        private final boolean usePersistedSettings;
        private final boolean injectBuildVars;

        GenerateReportCallable(ATXConfig config, List<FilePath> reportFiles, boolean usePersistedSettings, boolean injectBuildVars, EnvVars envVars, TaskListener listener) {
            super(config, reportFiles, envVars, listener);
            this.usePersistedSettings = usePersistedSettings;
            this.injectBuildVars = injectBuildVars;
        }

        public Boolean call() {
            boolean isGenerated = true;
            TTConsoleLogger logger = new TTConsoleLogger(this.getListener());
            Map<String, String> configMap = this.getConfigMap(false, this.injectBuildVars);
            String progId = ETComProperty.getInstance().getProgId();
            try (ETComClient comClient = new ETComClient(progId);){
                TestEnvironment testEnv = (TestEnvironment)comClient.getTestEnvironment();
                List<FilePath> reportFiles = this.getReportFiles();
                if (reportFiles.isEmpty()) {
                    logger.logInfo("-> No report files found to generate!");
                } else {
                    for (FilePath reportFile : reportFiles) {
                        logger.logInfo(String.format("-> Generating ATX report: %s", reportFile.getRemote()));
                        FilePath outDir = reportFile.getParent().child("ATX");
                        if (this.usePersistedSettings) {
                            FilePath reportDir = reportFile.getParent();
                            FilePath configPath = reportDir.child("ATX.xml");
                            logger.logInfo(String.format("- Using persisted settings from configuration: %s", configPath.getRemote()));
                            testEnv.generateTestReportDocument(reportFile.getRemote(), reportDir.getRemote(), configPath.getRemote(), true);
                        } else {
                            testEnv.generateTestReportDocumentFromDB(reportFile.getRemote(), outDir.getRemote(), "ATX", true, configMap);
                        }
                        comClient.waitForIdle(0);
                    }
                }
            }
            catch (ETComException e) {
                isGenerated = false;
                logger.logComException(e);
            }
            return isGenerated;
        }
    }
}

