/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report.atx;

import de.tracetronic.jenkins.plugins.ecutest.ETPluginException;
import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.report.AbstractReportDescriptor;
import de.tracetronic.jenkins.plugins.ecutest.report.AbstractReportPublisher;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.ATXReportGenerator;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.ATXReportUploader;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.Messages;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXBooleanSetting;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXConfig;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXInstallation;
import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXSetting;
import de.tracetronic.jenkins.plugins.ecutest.tool.client.ETClient;
import de.tracetronic.jenkins.plugins.ecutest.util.ATXUtil;
import de.tracetronic.jenkins.plugins.ecutest.util.EnvUtil;
import de.tracetronic.jenkins.plugins.ecutest.util.ProcessUtil;
import de.tracetronic.jenkins.plugins.ecutest.util.validation.ATXValidator;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ATXPublisher
extends AbstractReportPublisher {
    protected static final String URL_NAME = "atx-reports";
    @Nonnull
    private final String atxName;
    private ATXInstallation atxInstallation;
    private boolean failOnOffline;
    private boolean usePersistedSettings;
    private boolean injectBuildVars;

    @DataBoundConstructor
    public ATXPublisher(@Nonnull String atxName) {
        this.atxName = StringUtils.trimToEmpty((String)atxName);
    }

    @Nonnull
    public String getAtxName() {
        return this.atxName;
    }

    public ATXInstallation getAtxInstallation() {
        return this.atxInstallation;
    }

    @DataBoundSetter
    public void setAtxInstallation(ATXInstallation atxInstallation) {
        this.atxInstallation = atxInstallation;
    }

    public boolean isFailOnOffline() {
        return this.failOnOffline;
    }

    @DataBoundSetter
    public void setFailOnOffline(boolean failOnOffline) {
        this.failOnOffline = failOnOffline;
    }

    public boolean isUsePersistedSettings() {
        return this.usePersistedSettings;
    }

    @DataBoundSetter
    public void setUsePersistedSettings(boolean usePersistedSettings) {
        this.usePersistedSettings = usePersistedSettings;
    }

    public boolean isInjectBuildVars() {
        return this.injectBuildVars;
    }

    @DataBoundSetter
    public void setInjectBuildVars(boolean injectBuildVars) {
        this.injectBuildVars = injectBuildVars;
    }

    @Override
    public void performReport(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException, ETPluginException {
        EnvVars envVars = run.getEnvironment(listener);
        ProcessUtil.checkOS(launcher);
        if (this.isSkipped(true, run, launcher)) {
            return;
        }
        if (this.atxInstallation == null) {
            this.atxInstallation = this.getInstallation(envVars);
            if (this.atxInstallation == null) {
                throw new ETPluginException("Selected TEST-GUIDE installation is not configured!");
            }
        }
        TTConsoleLogger logger = this.getLogger();
        String serverName = EnvUtil.expandEnvVar(this.getAtxName(), envVars, this.atxInstallation.getName());
        logger.logInfo(String.format("Publishing ATX reports to %s...", serverName));
        boolean isPublished = false;
        if (this.isETRunning(launcher, listener)) {
            isPublished = this.publishReports(this.atxInstallation, run, workspace, launcher, listener);
        } else {
            String toolName = this.atxInstallation.getToolName();
            ETClient etClient = this.getToolClient(toolName, run, workspace, launcher, listener);
            if (etClient.start(false, workspace, launcher, listener)) {
                isPublished = this.publishReports(this.atxInstallation, run, workspace, launcher, listener);
            } else {
                logger.logError(String.format("Starting %s failed.", toolName));
            }
            if (!etClient.stop(true, workspace, launcher, listener)) {
                logger.logError(String.format("Stopping %s failed.", toolName));
            }
        }
        if (isPublished) {
            logger.logInfo("ATX reports published successfully.");
        } else {
            run.setResult(Result.FAILURE);
        }
    }

    private boolean publishReports(ATXInstallation installation, Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        TTConsoleLogger logger = this.getLogger();
        List<FilePath> reportDirs = this.getReportDirs(run, workspace, launcher);
        boolean isUploadEnabled = this.isUploadEnabled(installation);
        boolean isServerReachable = this.isServerReachable(installation, run, launcher, listener);
        if (isUploadEnabled && isServerReachable) {
            logger.logInfo("- Generating and uploading ATX reports...");
            ATXReportUploader uploader = new ATXReportUploader(installation);
            return uploader.upload(reportDirs, this.isUsePersistedSettings(), this.isInjectBuildVars(), this.isAllowMissing(), run, launcher, listener);
        }
        if (isUploadEnabled && this.failOnOffline) {
            logger.logError("-> TEST-GUIDE server is not reachable, setting build status to FAILURE!");
            return false;
        }
        logger.logInfo("- Generating ATX reports...");
        if (!isServerReachable) {
            logger.logWarn("-> ATX upload will be skipped because selected TEST-GUIDE server is not reachable!");
        }
        FilePath archiveTarget = this.getArchiveTarget(run);
        ATXReportGenerator generator = new ATXReportGenerator(installation);
        return generator.generate(archiveTarget, reportDirs, this.isUsePersistedSettings(), this.isInjectBuildVars(), this.isAllowMissing(), this.isArchiving(), this.isKeepAll(), run, launcher, listener);
    }

    private boolean isUploadEnabled(ATXInstallation installation) {
        ATXConfig config = installation.getConfig();
        Optional<ATXSetting<?>> uploadSetting = config.getSettingByName("uploadToServer");
        return uploadSetting.isPresent() && (Boolean)((ATXBooleanSetting)uploadSetting.get()).getValue() != false;
    }

    private boolean isServerReachable(ATXInstallation installation, Run<?, ?> run, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        ATXConfig config = installation.getConfig();
        EnvVars envVars = run.getEnvironment(listener);
        return (Boolean)launcher.getChannel().call((Callable)new TestConnectionCallable(config, envVars, listener));
    }

    @CheckForNull
    public ATXInstallation getInstallation() {
        return this.getInstallation(new EnvVars());
    }

    @CheckForNull
    public ATXInstallation getInstallation(EnvVars envVars) {
        String expandedName = envVars.expand(this.atxName);
        return ATXInstallation.get(expandedName);
    }

    @Override
    public String getUrlName() {
        return URL_NAME;
    }

    @Symbol(value={"publishATX"})
    @Extension(ordinal=10007.0)
    public static class DescriptorImpl
    extends AbstractReportDescriptor {
        public ATXInstallation[] getInstallations() {
            return ATXInstallation.all();
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.ATXPublisher_DisplayName();
        }
    }

    private static final class TestConnectionCallable
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private final ATXConfig config;
        private final EnvVars envVars;
        private final TaskListener listener;

        TestConnectionCallable(ATXConfig config, EnvVars envVars, TaskListener listener) {
            this.config = config;
            this.envVars = envVars;
            this.listener = listener;
        }

        public Boolean call() throws IOException {
            Object ignoreSSL = this.config.getSettingValueByGroup("ignoreSSL", ATXSetting.SettingsGroup.CONNECTION);
            if (ignoreSSL != null) {
                String baseUrl = ATXUtil.getBaseUrl(this.config, this.envVars);
                String proxyUrl = ATXUtil.getProxyUrl(this.config, this.envVars);
                ATXValidator validator = new ATXValidator();
                FormValidation validation = validator.testConnection(baseUrl, proxyUrl, (Boolean)ignoreSSL);
                if (validation.kind.equals((Object)FormValidation.Kind.WARNING)) {
                    TTConsoleLogger logger = new TTConsoleLogger(this.listener);
                    logger.logWarn(validation.getMessage());
                    return true;
                }
                return validation.kind.equals((Object)FormValidation.Kind.OK);
            }
            return false;
        }
    }
}

