/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report;

import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import de.tracetronic.jenkins.plugins.ecutest.report.AbstractReportDescriptor;
import de.tracetronic.jenkins.plugins.ecutest.report.AbstractReportPublisher;
import de.tracetronic.jenkins.plugins.ecutest.report.Messages;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DownStreamPublisher
extends Recorder
implements SimpleBuildStep {
    protected static final String DEFAULT_REPORT_DIR = "TestReports";
    @Nonnull
    private final String workspace;
    @Nonnull
    private List<AbstractReportPublisher> publishers = new ArrayList<AbstractReportPublisher>();
    private final String reportDir;

    @DataBoundConstructor
    public DownStreamPublisher(String workspace, String reportDir) {
        this.workspace = StringUtils.trimToEmpty((String)workspace);
        this.reportDir = StringUtils.defaultString((String)reportDir, (String)DownStreamPublisher.getDefaultReportDir());
    }

    public static String getDefaultReportDir() {
        return DEFAULT_REPORT_DIR;
    }

    @Nonnull
    public String getWorkspace() {
        return this.workspace;
    }

    @Nonnull
    public List<AbstractReportPublisher> getPublishers() {
        return this.publishers;
    }

    @DataBoundSetter
    public void setPublishers(List<AbstractReportPublisher> publishers) {
        this.publishers = publishers == null ? new ArrayList() : publishers;
    }

    public String getReportDir() {
        return this.reportDir;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        TTConsoleLogger logger = new TTConsoleLogger(listener);
        logger.logInfo("Publishing downstream reports...");
        for (AbstractReportPublisher publisher : this.getPublishers()) {
            if (publisher == null) continue;
            publisher.setDownstream(true);
            publisher.setWorkspace(this.getWorkspace());
            publisher.setReportDir(this.getReportDir());
            publisher.perform(run, workspace, launcher, listener);
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public AbstractReportDescriptor getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Symbol(value={"downstreamPublisher"})
    @Extension(ordinal=10000.0)
    public static final class DescriptorImpl
    extends AbstractReportDescriptor {
        public static String getDefaultReportDir() {
            return DownStreamPublisher.DEFAULT_REPORT_DIR;
        }

        public static List<Descriptor<? extends Publisher>> getApplicablePublishers() {
            ArrayList<Descriptor<? extends Publisher>> list = new ArrayList<Descriptor<? extends Publisher>>();
            DescriptorExtensionList publishers = AbstractReportPublisher.all();
            if (publishers != null) {
                for (Descriptor publisher : publishers) {
                    if (!(publisher instanceof AbstractReportDescriptor) || publisher instanceof DescriptorImpl) continue;
                    list.add((Descriptor<? extends Publisher>)publisher);
                }
            }
            return list;
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.DownStreamPublisher_DisplayName();
        }
    }
}

