/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report;

import de.tracetronic.jenkins.plugins.ecutest.ETPluginException;
import de.tracetronic.jenkins.plugins.ecutest.report.AbstractReportPublisher;
import de.tracetronic.jenkins.plugins.ecutest.tool.client.ETClient;
import de.tracetronic.jenkins.plugins.ecutest.tool.client.ETComRegisterClient;
import de.tracetronic.jenkins.plugins.ecutest.tool.installation.ETInstallation;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Computer;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundSetter;

public abstract class AbstractToolPublisher
extends AbstractReportPublisher {
    @Nonnull
    private String toolName;
    private ETInstallation installation;

    public AbstractToolPublisher(@Nonnull String toolName) {
        this.toolName = StringUtils.trimToEmpty((String)toolName);
    }

    public AbstractToolPublisher(@Nonnull String toolName, boolean allowMissing, boolean runOnFailed, boolean archiving, boolean keepAll) {
        super(allowMissing, runOnFailed, archiving, keepAll);
        this.toolName = StringUtils.trimToEmpty((String)toolName);
    }

    @Nonnull
    public String getToolName() {
        return this.toolName;
    }

    public ETInstallation getInstallation() {
        return this.installation;
    }

    @DataBoundSetter
    public void setInstallation(ETInstallation installation) {
        this.installation = installation;
        this.toolName = this.installation.getName();
    }

    protected ETClient getToolClient(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException, ETPluginException {
        String installPath;
        if (!this.isInstallationVerified(run.getEnvironment(listener))) {
            this.installation = this.configureToolInstallation(workspace.toComputer(), listener, run.getEnvironment(listener));
        }
        String expandedToolName = run.getEnvironment(listener).expand(this.installation.getName());
        if (this.installation.isRegisterComServer()) {
            installPath = this.getInstallation().getComExecutable(launcher);
            ETComRegisterClient comClient = new ETComRegisterClient(expandedToolName, installPath);
            comClient.start(false, workspace, launcher, listener);
        }
        installPath = this.installation.getExecutable(launcher);
        String workspaceDir = this.getWorkspaceDir(run, workspace);
        String settingsDir = this.getSettingsDir(run, workspace);
        return new ETClient(expandedToolName, installPath, workspaceDir, settingsDir, 120, false);
    }

    protected ETInstallation configureToolInstallation(Computer computer, TaskListener listener, EnvVars envVars) throws IOException, InterruptedException, ETPluginException {
        return this.configureToolInstallation(this.toolName, computer, listener, envVars);
    }

    public boolean isInstallationVerified(EnvVars envVars) {
        if (this.getInstallation() == null) {
            return false;
        }
        return this.getInstallation().getName().equals(envVars.expand(this.getToolName()));
    }
}

