/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.report;

import de.tracetronic.jenkins.plugins.ecutest.ETPlugin;
import de.tracetronic.jenkins.plugins.ecutest.report.AbstractRequestHandler;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import java.io.File;
import javax.annotation.CheckForNull;
import jenkins.util.VirtualFile;
import org.jenkins.ui.icon.IconSpec;
import org.kohsuke.stapler.StaplerRequest;

public abstract class AbstractReportAction
extends AbstractRequestHandler
implements Action,
IconSpec {
    private final boolean projectLevel;

    public AbstractReportAction(boolean projectLevel) {
        this.projectLevel = projectLevel;
    }

    public boolean isProjectLevel() {
        return this.projectLevel;
    }

    @Override
    public Run<?, ?> getBuild(StaplerRequest req) {
        Run<?, ?> build = this.getAnchestorBuild(req);
        if (build != null) {
            return build;
        }
        Job<?, ?> project = this.getAnchestorProject(req);
        if (project != null) {
            return this.getLastReportBuild(project);
        }
        return null;
    }

    @Override
    protected VirtualFile getArchiveTargetDir(File rootDir) {
        String urlName = this.getUrlName();
        if (urlName != null) {
            return VirtualFile.forFile((File)new File(rootDir, urlName));
        }
        return VirtualFile.forFile((File)rootDir);
    }

    @CheckForNull
    protected abstract Run<?, ?> getLastReportBuild(Job<?, ?> var1);

    public String getIconFileName() {
        return ETPlugin.getIconFileName(this.getIconClassName(), "icon-xlg");
    }
}

