/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.log;

import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleAnnotator;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import org.apache.commons.lang.exception.ExceptionUtils;

public class TTConsoleLogger {
    private final TaskListener listener;
    private final TTConsoleAnnotator annotator;

    public TTConsoleLogger(TaskListener listener) {
        this.listener = listener;
        this.annotator = new TTConsoleAnnotator(this.listener.getLogger());
    }

    public PrintStream getLogger() {
        return this.listener.getLogger();
    }

    public void logAnnot(String message) {
        this.logAnnot("", message);
    }

    public void logAnnot(String prefix, String message) {
        String log = prefix + message + "\n";
        byte[] msg = log.getBytes(Charset.defaultCharset());
        try {
            this.annotator.eol(msg, msg.length);
        }
        catch (IOException e) {
            this.listener.getLogger().println("Problem with writing into console log: " + e.getMessage());
        }
    }

    public void logInfo(String message) {
        this.logAnnot("[TT] INFO: ", message);
    }

    public void logWarn(String message) {
        this.logAnnot("[TT] WARN: ", message);
    }

    public void logError(String message) {
        this.logAnnot("[TT] ERROR: ", message);
    }

    public void logComException(Exception exception) {
        this.logError(String.format("Caught ComException: %s%n%s%n%s%n", exception.getMessage(), "For further information see FAQ: https://github.com/jenkinsci/ecutest-plugin#faq", "Enable debug mode for fine-grained logs: https://github.com/jenkinsci/ecutest-plugin#debugging"));
        this.logStackTrace(exception);
    }

    public void logComException(String message, Exception exception) {
        this.logError(String.format("%s: %s", message, exception.getMessage()));
        this.logStackTrace(exception);
    }

    public void logDebug(String message) {
        if (Boolean.getBoolean("ecutest.debugLog")) {
            this.logAnnot("[TT] DEBUG: ", message);
        }
    }

    public void logStackTrace(Exception exception) {
        this.logDebug(ExceptionUtils.getFullStackTrace((Throwable)exception));
    }

    public void log(String message) {
        this.listener.getLogger().println(message);
    }
}

