/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.extension.warnings;

import de.tracetronic.jenkins.plugins.ecutest.log.TTConsoleLogger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.analysis.core.model.ResultAction;
import io.jenkins.plugins.analysis.core.model.Tool;
import io.jenkins.plugins.analysis.core.steps.IssuesRecorder;
import io.jenkins.plugins.analysis.core.util.RunResultHandler;
import io.jenkins.plugins.analysis.core.util.StageResultHandler;
import io.jenkins.plugins.analysis.warnings.WarningsPlugin;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Optional;
import org.apache.commons.lang.RandomStringUtils;

public class WarningsRecorder {
    private final String displayName;
    private final String issueName;
    private final String issueFileName;

    public WarningsRecorder(String displayName, String issueName, String issueFileName) {
        this.displayName = displayName;
        this.issueName = issueName;
        this.issueFileName = issueFileName;
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    public boolean record(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        boolean hasIssues = false;
        WarningsPlugin plugin = new WarningsPlugin();
        plugin.setName(this.displayName);
        plugin.setPattern(this.issueFileName);
        plugin.setReportEncoding("UTF-8");
        plugin.setId(String.format("%s-%s", this.issueName, RandomStringUtils.randomAlphanumeric((int)8)));
        IssuesRecorder recorder = new IssuesRecorder();
        recorder.setTools((Tool)plugin, new Tool[0]);
        recorder.setFailOnError(false);
        recorder.setEnabledForFailure(true);
        recorder.setMinimumSeverity("ERROR");
        if (run instanceof AbstractBuild) {
            recorder.perform((AbstractBuild)run, launcher, (BuildListener)listener);
        } else {
            Class<?> clazz = recorder.getClass();
            try {
                Method perform = clazz.getDeclaredMethod("perform", Run.class, FilePath.class, TaskListener.class, StageResultHandler.class);
                AccessController.doPrivileged(() -> {
                    perform.setAccessible(true);
                    return null;
                });
                perform.invoke((Object)recorder, run, workspace, listener, new RunResultHandler(run));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                TTConsoleLogger logger = new TTConsoleLogger(listener);
                logger.logError(String.format("Could not invoke Warnings NG recorder: %s", e.getMessage()));
                return true;
            }
        }
        Optional<ResultAction> result = run.getActions(ResultAction.class).stream().filter(action -> action.getId().equals(plugin.getId())).findFirst();
        if (result.isPresent() && result.get().getResult().getIssues().getSizeOf("ERROR") > 0) {
            run.setResult(Result.FAILURE);
            hasIssues = true;
        }
        return hasIssues;
    }
}

