/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.extension.jobdsl;

import com.google.common.base.Preconditions;
import de.tracetronic.jenkins.plugins.ecutest.extension.jobdsl.AbstractTestBuilderDslExtension;
import de.tracetronic.jenkins.plugins.ecutest.test.ExportPackageBuilder;
import de.tracetronic.jenkins.plugins.ecutest.test.ExportProjectBuilder;
import de.tracetronic.jenkins.plugins.ecutest.test.ImportPackageBuilder;
import de.tracetronic.jenkins.plugins.ecutest.test.ImportProjectBuilder;
import de.tracetronic.jenkins.plugins.ecutest.test.TestFolderBuilder;
import de.tracetronic.jenkins.plugins.ecutest.test.TestPackageBuilder;
import de.tracetronic.jenkins.plugins.ecutest.test.TestProjectBuilder;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ExportPackageAttributeConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ExportPackageConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ExportProjectAttributeConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ExportProjectConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportPackageAttributeConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportPackageConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportPackageDirConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportProjectArchiveConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportProjectAttributeConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportProjectConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportProjectDirConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.PackageConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.PackageOutputParameter;
import de.tracetronic.jenkins.plugins.ecutest.test.config.PackageParameter;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ProjectConfig;
import hudson.Extension;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.List;
import javaposse.jobdsl.dsl.Context;
import javaposse.jobdsl.dsl.helpers.step.StepContext;
import javaposse.jobdsl.plugin.ContextExtensionPoint;
import javaposse.jobdsl.plugin.DslExtensionMethod;

@Extension(optional=true)
public class TestBuilderDslExtension
extends AbstractTestBuilderDslExtension {
    @DslExtensionMethod(context=StepContext.class)
    public Object testPackage(CharSequence pkgFile, Runnable closure) {
        Preconditions.checkNotNull((Object)pkgFile, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"testFile"});
        TestPackageContext context = new TestPackageContext();
        TestBuilderDslExtension.executeInContext((Runnable)closure, (Context)context);
        TestPackageBuilder builder = new TestPackageBuilder(pkgFile.toString());
        builder.setTestConfig(context.testConfig);
        builder.setPackageConfig(context.packageConfig);
        builder.setExecutionConfig(context.executionConfig);
        return builder;
    }

    @DslExtensionMethod(context=StepContext.class)
    public Object testPackage(CharSequence pkgFile) {
        return this.testPackage(pkgFile, null);
    }

    @DslExtensionMethod(context=StepContext.class)
    public Object testProject(CharSequence prjFile, Runnable closure) {
        Preconditions.checkNotNull((Object)prjFile, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"testFile"});
        TestProjectContext context = new TestProjectContext();
        TestBuilderDslExtension.executeInContext((Runnable)closure, (Context)context);
        TestProjectBuilder builder = new TestProjectBuilder(prjFile.toString());
        builder.setTestConfig(context.testConfig);
        builder.setProjectConfig(context.projectConfig);
        builder.setExecutionConfig(context.executionConfig);
        return builder;
    }

    @DslExtensionMethod(context=StepContext.class)
    public Object testProject(CharSequence prjFile) {
        return this.testProject(prjFile, null);
    }

    @DslExtensionMethod(context=StepContext.class)
    public Object testFolder(CharSequence testFolder, Runnable closure) {
        Preconditions.checkNotNull((Object)testFolder, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"testFile"});
        TestFolderContext context = new TestFolderContext();
        TestBuilderDslExtension.executeInContext((Runnable)closure, (Context)context);
        TestFolderBuilder builder = new TestFolderBuilder(testFolder.toString());
        builder.setScanMode(context.scanMode);
        builder.setRecursiveScan(context.recursiveScan);
        builder.setTestConfig(context.testConfig);
        builder.setPackageConfig(context.packageConfig);
        builder.setProjectConfig(context.projectConfig);
        builder.setExecutionConfig(context.executionConfig);
        return builder;
    }

    @DslExtensionMethod(context=StepContext.class)
    public Object testFolder(CharSequence testFolder) {
        return this.testFolder(testFolder, null);
    }

    @DslExtensionMethod(context=StepContext.class)
    public Object importPackages(Runnable closure) {
        ImportPackageContext context = new ImportPackageContext();
        TestBuilderDslExtension.executeInContext((Runnable)closure, (Context)context);
        return new ImportPackageBuilder(context.importConfigs);
    }

    @DslExtensionMethod(context=StepContext.class)
    public Object importPackages() {
        return this.importPackages(null);
    }

    @DslExtensionMethod(context=StepContext.class)
    public Object importProjects(Runnable closure) {
        ImportProjectContext context = new ImportProjectContext();
        TestBuilderDslExtension.executeInContext((Runnable)closure, (Context)context);
        return new ImportProjectBuilder(context.importConfigs);
    }

    @DslExtensionMethod(context=StepContext.class)
    public Object importProjects() {
        return this.importProjects(null);
    }

    @DslExtensionMethod(context=StepContext.class)
    public Object exportPackages(Runnable closure) {
        ExportPackageContext context = new ExportPackageContext();
        TestBuilderDslExtension.executeInContext((Runnable)closure, (Context)context);
        return new ExportPackageBuilder(context.exportConfigs);
    }

    @DslExtensionMethod(context=StepContext.class)
    public Object exportPackages() {
        return this.exportPackages(null);
    }

    @DslExtensionMethod(context=StepContext.class)
    public Object exportProjects(Runnable closure) {
        ExportProjectContext context = new ExportProjectContext();
        TestBuilderDslExtension.executeInContext((Runnable)closure, (Context)context);
        return new ExportProjectBuilder(context.exportConfigs);
    }

    @DslExtensionMethod(context=StepContext.class)
    public Object exportProjects() {
        return this.exportProjects(null);
    }

    public class ExportProjectContext
    extends AbstractTestBuilderDslExtension.AbstractExportContext {
        private static final String OPT_PROJECT_PATH = "projectPath";

        public void exportToTMS(CharSequence credentialsId, CharSequence projectPath, CharSequence exportPath, boolean createNewPath, CharSequence timeout) {
            Preconditions.checkNotNull((Object)credentialsId, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"credentialsId"});
            Preconditions.checkNotNull((Object)projectPath, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_PROJECT_PATH});
            Preconditions.checkNotNull((Object)exportPath, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"exportPath"});
            Preconditions.checkNotNull((Object)timeout, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"timeout"});
            FormValidation validation = TestBuilderDslExtension.this.validator.validateProjectFile(projectPath.toString());
            Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
            validation = TestBuilderDslExtension.this.tmsValidator.validateExportPath(exportPath.toString());
            Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
            this.exportConfigs.add(new ExportProjectConfig(projectPath.toString(), exportPath.toString(), createNewPath, credentialsId.toString(), timeout.toString()));
        }

        public void exportToTMS(CharSequence credentialsId, CharSequence projectPath, CharSequence exportPath, int timeout) {
            this.exportToTMS(credentialsId, projectPath, exportPath, false, String.valueOf(timeout));
        }

        public void exportToTMS(CharSequence credentialsId, CharSequence projectPath, Runnable closure) {
            Preconditions.checkNotNull((Object)credentialsId, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"credentialsId"});
            Preconditions.checkNotNull((Object)projectPath, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_PROJECT_PATH});
            AbstractTestBuilderDslExtension.AbstractExportContext.ExportTMSContext context = new AbstractTestBuilderDslExtension.AbstractExportContext.ExportTMSContext();
            ContextExtensionPoint.executeInContext((Runnable)closure, (Context)context);
            this.exportConfigs.add(new ExportProjectConfig(projectPath.toString(), context.exportPath, context.createNewPath, credentialsId.toString(), context.timeout));
        }

        public void exportAttributesToTMS(CharSequence credentialsId, CharSequence projectPath, CharSequence timeout) {
            Preconditions.checkNotNull((Object)credentialsId, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"credentialsId"});
            Preconditions.checkNotNull((Object)projectPath, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_PROJECT_PATH});
            Preconditions.checkNotNull((Object)timeout, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"timeout"});
            FormValidation validation = TestBuilderDslExtension.this.tmsValidator.validateProjectFile(projectPath.toString());
            Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
            this.exportConfigs.add(new ExportProjectAttributeConfig(projectPath.toString(), credentialsId.toString(), timeout.toString()));
        }

        public void exportAttributesToTMS(CharSequence credentialsId, CharSequence projectPath, int timeout) {
            this.exportAttributesToTMS(credentialsId, projectPath, String.valueOf(timeout));
        }

        public void exportAttributesToTMS(CharSequence credentialsId, CharSequence projectPath, Runnable closure) {
            Preconditions.checkNotNull((Object)credentialsId, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"credentialsId"});
            Preconditions.checkNotNull((Object)projectPath, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_PROJECT_PATH});
            AbstractTestBuilderDslExtension.AbstractExportContext.ExportTMSContext context = new AbstractTestBuilderDslExtension.AbstractExportContext.ExportTMSContext();
            ContextExtensionPoint.executeInContext((Runnable)closure, (Context)context);
            this.exportConfigs.add(new ExportProjectAttributeConfig(projectPath.toString(), credentialsId.toString(), context.timeout));
        }
    }

    public class ExportPackageContext
    extends AbstractTestBuilderDslExtension.AbstractExportContext {
        private static final String OPT_PACKAGE_PATH = "packagePath";

        public void exportToTMS(CharSequence credentialsId, CharSequence packagePath, CharSequence exportPath, boolean createNewPath, CharSequence timeout) {
            Preconditions.checkNotNull((Object)credentialsId, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"credentialsId"});
            Preconditions.checkNotNull((Object)packagePath, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_PACKAGE_PATH});
            Preconditions.checkNotNull((Object)exportPath, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"exportPath"});
            Preconditions.checkNotNull((Object)timeout, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"timeout"});
            FormValidation validation = TestBuilderDslExtension.this.tmsValidator.validatePackageFile(packagePath.toString());
            Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
            validation = TestBuilderDslExtension.this.tmsValidator.validateExportPath(exportPath.toString());
            Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
            this.exportConfigs.add(new ExportPackageConfig(packagePath.toString(), exportPath.toString(), createNewPath, credentialsId.toString(), timeout.toString()));
        }

        public void exportToTMS(CharSequence credentialsId, CharSequence packagePath, CharSequence exportPath, int timeout) {
            this.exportToTMS(credentialsId, packagePath, exportPath, false, String.valueOf(timeout));
        }

        public void exportToTMS(CharSequence credentialsId, CharSequence packagePath, Runnable closure) {
            Preconditions.checkNotNull((Object)credentialsId, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"credentialsId"});
            Preconditions.checkNotNull((Object)packagePath, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_PACKAGE_PATH});
            AbstractTestBuilderDslExtension.AbstractExportContext.ExportTMSContext context = new AbstractTestBuilderDslExtension.AbstractExportContext.ExportTMSContext();
            ContextExtensionPoint.executeInContext((Runnable)closure, (Context)context);
            this.exportConfigs.add(new ExportPackageConfig(packagePath.toString(), context.exportPath, context.createNewPath, credentialsId.toString(), context.timeout));
        }

        public void exportAttributesToTMS(CharSequence credentialsId, CharSequence packagePath, CharSequence timeout) {
            Preconditions.checkNotNull((Object)credentialsId, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"credentialsId"});
            Preconditions.checkNotNull((Object)packagePath, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_PACKAGE_PATH});
            Preconditions.checkNotNull((Object)timeout, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"timeout"});
            FormValidation validation = TestBuilderDslExtension.this.tmsValidator.validatePackageFile(packagePath.toString());
            Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
            this.exportConfigs.add(new ExportPackageAttributeConfig(packagePath.toString(), credentialsId.toString(), timeout.toString()));
        }

        public void exportAttributesToTMS(CharSequence credentialsId, CharSequence packagePath, int timeout) {
            this.exportAttributesToTMS(credentialsId, packagePath, String.valueOf(timeout));
        }

        public void exportAttributesToTMS(CharSequence credentialsId, CharSequence packagePath, Runnable closure) {
            Preconditions.checkNotNull((Object)credentialsId, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"credentialsId"});
            Preconditions.checkNotNull((Object)packagePath, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_PACKAGE_PATH});
            AbstractTestBuilderDslExtension.AbstractExportContext.ExportTMSContext context = new AbstractTestBuilderDslExtension.AbstractExportContext.ExportTMSContext();
            ContextExtensionPoint.executeInContext((Runnable)closure, (Context)context);
            this.exportConfigs.add(new ExportPackageAttributeConfig(packagePath.toString(), credentialsId.toString(), context.timeout));
        }
    }

    public class ImportProjectContext
    extends AbstractTestBuilderDslExtension.AbstractImportContext {
        private static final String OPT_ARCHIVE_PATH = "archivePath";
        private static final String OPT_PROJECT_PATH = "projectPath";
        private static final String OPT_PROJECT_DIR_PATH = "projectDirPath";
        private static final String OPT_IMPORT_CONFIG_PATH = "importConfigPath";

        public void importFromArchive(CharSequence archivePath, CharSequence importPath, CharSequence importConfigPath, boolean replaceFiles) {
            Preconditions.checkNotNull((Object)archivePath, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_ARCHIVE_PATH});
            Preconditions.checkNotNull((Object)importPath, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"importPath"});
            Preconditions.checkNotNull((Object)importConfigPath, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_IMPORT_CONFIG_PATH});
            FormValidation validation = TestBuilderDslExtension.this.tmsValidator.validateArchivePath(archivePath.toString());
            Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
            validation = TestBuilderDslExtension.this.tmsValidator.validateImportPath(importPath.toString());
            Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
            validation = TestBuilderDslExtension.this.tmsValidator.validateImportConfigPath(importConfigPath.toString());
            Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
            this.importConfigs.add(new ImportProjectArchiveConfig(archivePath.toString(), importPath.toString(), importConfigPath.toString(), replaceFiles));
        }

        public void importFromArchive(CharSequence archivePath, Runnable closure) {
            Preconditions.checkNotNull((Object)archivePath, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_ARCHIVE_PATH});
            ImportArchiveContext context = new ImportArchiveContext();
            ContextExtensionPoint.executeInContext((Runnable)closure, (Context)context);
            this.importConfigs.add(new ImportProjectArchiveConfig(archivePath.toString(), context.importPath, context.importConfigPath, context.replaceFiles));
        }

        public void importFromTMS(CharSequence credentialsId, CharSequence projectPath, CharSequence importPath, boolean importMissingPackages, CharSequence timeout) {
            Preconditions.checkNotNull((Object)credentialsId, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"credentialsId"});
            Preconditions.checkNotNull((Object)projectPath, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_PROJECT_PATH});
            Preconditions.checkNotNull((Object)importPath, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"importPath"});
            Preconditions.checkNotNull((Object)timeout, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"timeout"});
            FormValidation validation = TestBuilderDslExtension.this.tmsValidator.validateTestPath(projectPath.toString());
            Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
            validation = TestBuilderDslExtension.this.tmsValidator.validateImportPath(importPath.toString());
            Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
            this.importConfigs.add(new ImportProjectConfig(projectPath.toString(), importPath.toString(), importMissingPackages, credentialsId.toString(), timeout.toString()));
        }

        public void importFromTMS(CharSequence credentialsId, CharSequence projectPath, CharSequence importPath, int timeout) {
            this.importFromTMS(credentialsId, projectPath, importPath, false, String.valueOf(timeout));
        }

        public void importFromTMS(CharSequence credentialsId, CharSequence projectPath, CharSequence importPath, boolean importMissingPackages, int timeout) {
            this.importFromTMS(credentialsId, projectPath, importPath, importMissingPackages, String.valueOf(timeout));
        }

        public void importFromTMS(CharSequence credentialsId, CharSequence projectPath, Runnable closure) {
            Preconditions.checkNotNull((Object)credentialsId, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"credentialsId"});
            Preconditions.checkNotNull((Object)projectPath, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_PROJECT_PATH});
            AbstractTestBuilderDslExtension.AbstractImportContext.ImportTMSContext context = new AbstractTestBuilderDslExtension.AbstractImportContext.ImportTMSContext();
            ContextExtensionPoint.executeInContext((Runnable)closure, (Context)context);
            this.importConfigs.add(new ImportProjectConfig(projectPath.toString(), context.importPath, context.importMissingPackages, credentialsId.toString(), context.timeout));
        }

        public void importFromTMSDir(CharSequence credentialsId, CharSequence projectDirPath, CharSequence importPath, CharSequence timeout) {
            Preconditions.checkNotNull((Object)credentialsId, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"credentialsId"});
            Preconditions.checkNotNull((Object)projectDirPath, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_PROJECT_DIR_PATH});
            Preconditions.checkNotNull((Object)importPath, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_PROJECT_PATH});
            Preconditions.checkNotNull((Object)timeout, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_PROJECT_PATH});
            FormValidation validation = TestBuilderDslExtension.this.tmsValidator.validateTestPath(projectDirPath.toString());
            Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
            validation = TestBuilderDslExtension.this.tmsValidator.validateImportPath(importPath.toString());
            Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
            this.importConfigs.add(new ImportProjectDirConfig(projectDirPath.toString(), importPath.toString(), credentialsId.toString(), timeout.toString()));
        }

        public void importFromTMSDir(CharSequence credentialsId, CharSequence projectDirPath, CharSequence importPath, int timeout) {
            this.importFromTMSDir(credentialsId, projectDirPath, importPath, String.valueOf(timeout));
        }

        public void importFromTMSDir(CharSequence credentialsId, CharSequence projectDirPath, Runnable closure) {
            Preconditions.checkNotNull((Object)credentialsId, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"credentialsId"});
            Preconditions.checkNotNull((Object)projectDirPath, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_PROJECT_DIR_PATH});
            AbstractTestBuilderDslExtension.AbstractImportContext.ImportTMSContext context = new AbstractTestBuilderDslExtension.AbstractImportContext.ImportTMSContext();
            ContextExtensionPoint.executeInContext((Runnable)closure, (Context)context);
            this.importConfigs.add(new ImportProjectDirConfig(projectDirPath.toString(), context.importPath, credentialsId.toString(), context.timeout));
        }

        public void importAttributesFromTMS(CharSequence credentialsId, CharSequence projectPath, CharSequence timeout) {
            Preconditions.checkNotNull((Object)credentialsId, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"credentialsId"});
            Preconditions.checkNotNull((Object)projectPath, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_PROJECT_PATH});
            Preconditions.checkNotNull((Object)timeout, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"timeout"});
            FormValidation validation = TestBuilderDslExtension.this.tmsValidator.validateProjectFile(projectPath.toString());
            Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
            this.importConfigs.add(new ImportProjectAttributeConfig(projectPath.toString(), credentialsId.toString(), timeout.toString()));
        }

        public void importAttributesFromTMS(CharSequence credentialsId, CharSequence projectPath, int timeout) {
            this.importAttributesFromTMS(credentialsId, projectPath, String.valueOf(timeout));
        }

        public void importAttributesFromTMS(CharSequence credentialsId, CharSequence projectPath, Runnable closure) {
            Preconditions.checkNotNull((Object)credentialsId, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"credentialsId"});
            Preconditions.checkNotNull((Object)projectPath, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_PROJECT_PATH});
            AbstractTestBuilderDslExtension.AbstractImportContext.ImportTMSContext context = new AbstractTestBuilderDslExtension.AbstractImportContext.ImportTMSContext();
            ContextExtensionPoint.executeInContext((Runnable)closure, (Context)context);
            this.importConfigs.add(new ImportProjectAttributeConfig(projectPath.toString(), credentialsId.toString(), context.timeout));
        }

        public class ImportArchiveContext
        extends AbstractTestBuilderDslExtension.AbstractImportContext {
            private String importConfigPath;
            private boolean replaceFiles = true;

            public void importConfigPath(String value) {
                FormValidation validation = TestBuilderDslExtension.this.tmsValidator.validateImportConfigPath(value);
                Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
                this.importConfigPath = value;
            }

            public void replaceFiles(boolean value) {
                this.replaceFiles = value;
            }
        }
    }

    public class ImportPackageContext
    extends AbstractTestBuilderDslExtension.AbstractImportContext {
        private static final String OPT_PACKAGE_PATH = "packagePath";
        private static final String OPT_PACKAGE_DIR_PATH = "packageDirPath";

        public void importFromTMS(CharSequence credentialsId, CharSequence packagePath, CharSequence importPath, CharSequence timeout) {
            Preconditions.checkNotNull((Object)credentialsId, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"credentialsId"});
            Preconditions.checkNotNull((Object)packagePath, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_PACKAGE_PATH});
            Preconditions.checkNotNull((Object)importPath, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"importPath"});
            Preconditions.checkNotNull((Object)timeout, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"timeout"});
            FormValidation validation = TestBuilderDslExtension.this.tmsValidator.validateTestPath(packagePath.toString());
            Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
            validation = TestBuilderDslExtension.this.tmsValidator.validateImportPath(importPath.toString());
            Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
            this.importConfigs.add(new ImportPackageConfig(packagePath.toString(), importPath.toString(), credentialsId.toString(), timeout.toString()));
        }

        public void importFromTMS(CharSequence credentialsId, CharSequence packagePath, CharSequence importPath, int timeout) {
            this.importFromTMS(credentialsId, packagePath, importPath, String.valueOf(timeout));
        }

        public void importFromTMS(CharSequence credentialsId, CharSequence packagePath, Runnable closure) {
            Preconditions.checkNotNull((Object)credentialsId, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"credentialsId"});
            Preconditions.checkNotNull((Object)packagePath, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_PACKAGE_PATH});
            AbstractTestBuilderDslExtension.AbstractImportContext.ImportTMSContext context = new AbstractTestBuilderDslExtension.AbstractImportContext.ImportTMSContext();
            ContextExtensionPoint.executeInContext((Runnable)closure, (Context)context);
            this.importConfigs.add(new ImportPackageConfig(packagePath.toString(), context.importPath, credentialsId.toString(), context.timeout));
        }

        public void importFromTMSDir(CharSequence credentialsId, CharSequence packageDirPath, CharSequence importPath, CharSequence timeout) {
            Preconditions.checkNotNull((Object)credentialsId, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"credentialsId"});
            Preconditions.checkNotNull((Object)packageDirPath, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_PACKAGE_DIR_PATH});
            Preconditions.checkNotNull((Object)importPath, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_PACKAGE_PATH});
            Preconditions.checkNotNull((Object)timeout, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_PACKAGE_PATH});
            FormValidation validation = TestBuilderDslExtension.this.tmsValidator.validateTestPath(packageDirPath.toString());
            Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
            validation = TestBuilderDslExtension.this.tmsValidator.validateImportPath(importPath.toString());
            Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
            this.importConfigs.add(new ImportPackageDirConfig(packageDirPath.toString(), importPath.toString(), credentialsId.toString(), timeout.toString()));
        }

        public void importFromTMSDir(CharSequence credentialsId, CharSequence packageDirPath, CharSequence importPath, int timeout) {
            this.importFromTMSDir(credentialsId, packageDirPath, importPath, String.valueOf(timeout));
        }

        public void importFromTMSDir(CharSequence credentialsId, CharSequence packagePath, Runnable closure) {
            Preconditions.checkNotNull((Object)credentialsId, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"credentialsId"});
            Preconditions.checkNotNull((Object)packagePath, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_PACKAGE_DIR_PATH});
            AbstractTestBuilderDslExtension.AbstractImportContext.ImportTMSContext context = new AbstractTestBuilderDslExtension.AbstractImportContext.ImportTMSContext();
            ContextExtensionPoint.executeInContext((Runnable)closure, (Context)context);
            this.importConfigs.add(new ImportPackageDirConfig(packagePath.toString(), context.importPath, credentialsId.toString(), context.timeout));
        }

        public void importAttributesFromTMS(CharSequence credentialsId, CharSequence packagePath, CharSequence timeout) {
            Preconditions.checkNotNull((Object)credentialsId, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"credentialsId"});
            Preconditions.checkNotNull((Object)packagePath, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_PACKAGE_PATH});
            Preconditions.checkNotNull((Object)timeout, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"timeout"});
            FormValidation validation = TestBuilderDslExtension.this.tmsValidator.validatePackageFile(packagePath.toString());
            Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
            this.importConfigs.add(new ImportPackageAttributeConfig(packagePath.toString(), credentialsId.toString(), timeout.toString()));
        }

        public void importAttributesFromTMS(CharSequence credentialsId, CharSequence packagePath, int timeout) {
            this.importAttributesFromTMS(credentialsId, packagePath, String.valueOf(timeout));
        }

        public void importAttributesFromTMS(CharSequence credentialsId, CharSequence packagePath, Runnable closure) {
            Preconditions.checkNotNull((Object)credentialsId, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"credentialsId"});
            Preconditions.checkNotNull((Object)packagePath, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_PACKAGE_PATH});
            AbstractTestBuilderDslExtension.AbstractImportContext.ImportTMSContext context = new AbstractTestBuilderDslExtension.AbstractImportContext.ImportTMSContext();
            ContextExtensionPoint.executeInContext((Runnable)closure, (Context)context);
            this.importConfigs.add(new ImportPackageAttributeConfig(packagePath.toString(), credentialsId.toString(), context.timeout));
        }
    }

    public class TestFolderContext
    extends AbstractTestBuilderDslExtension.AbstractTestContext {
        private TestFolderBuilder.ScanMode scanMode = TestFolderBuilder.ScanMode.PACKAGES_AND_PROJECTS;
        private boolean recursiveScan;
        private PackageConfig packageConfig;
        private ProjectConfig projectConfig;

        public void scanMode(CharSequence value) {
            this.scanMode = TestFolderBuilder.ScanMode.valueOf(value.toString());
        }

        public void recursiveScan(boolean value) {
            this.recursiveScan = value;
        }

        public void packageConfig(Runnable closure) {
            PackageConfigContext context = new PackageConfigContext();
            ContextExtensionPoint.executeInContext((Runnable)closure, (Context)context);
            this.packageConfig = new PackageConfig(context.runTest, context.runTraceAnalysis, context.parameters, context.outputParameters);
        }

        public void projectConfig(Runnable closure) {
            ProjectConfigContext context = new ProjectConfigContext();
            ContextExtensionPoint.executeInContext((Runnable)closure, (Context)context);
            this.projectConfig = new ProjectConfig(context.execInCurrentPkgDir, context.filterExpression, context.jobExecutionMode);
        }
    }

    public class ProjectConfigContext
    implements Context {
        private static final String OPT_FILTER_EXPR = "filterExpression";
        private static final String OPT_JOB_EXEC_MODE = "jobExecutionMode";
        private boolean execInCurrentPkgDir;
        private String filterExpression;
        private ProjectConfig.JobExecutionMode jobExecutionMode = ProjectConfig.JobExecutionMode.SEQUENTIAL_EXECUTION;

        public void execInCurrentPkgDir(boolean value) {
            this.execInCurrentPkgDir = value;
        }

        public void filterExpression(CharSequence value) {
            Preconditions.checkNotNull((Object)value, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_FILTER_EXPR});
            FormValidation validation = TestBuilderDslExtension.this.validator.validateFilterExpression(value.toString());
            Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
            this.filterExpression = value.toString();
        }

        public void jobExecutionMode(CharSequence value) {
            Preconditions.checkNotNull((Object)value, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_JOB_EXEC_MODE});
            this.jobExecutionMode = ProjectConfig.JobExecutionMode.valueOf(value.toString());
        }

        public void jobExecutionMode(int value) {
            this.jobExecutionMode = ProjectConfig.JobExecutionMode.fromValue(value);
        }
    }

    public class TestProjectContext
    extends AbstractTestBuilderDslExtension.AbstractTestContext {
        private ProjectConfig projectConfig;

        public void projectConfig(Runnable closure) {
            ProjectConfigContext context = new ProjectConfigContext();
            ContextExtensionPoint.executeInContext((Runnable)closure, (Context)context);
            this.projectConfig = new ProjectConfig(context.execInCurrentPkgDir, context.filterExpression, context.jobExecutionMode);
        }
    }

    public class PackageConfigContext
    implements Context {
        private boolean runTest = true;
        private boolean runTraceAnalysis = true;
        private List<PackageParameter> parameters;
        private List<PackageOutputParameter> outputParameters;

        public void runTest(boolean value) {
            this.runTest = value;
        }

        public void runTraceAnalysis(boolean value) {
            this.runTraceAnalysis = value;
        }

        public void parameters(Runnable closure) {
            PackageParametersContext context = new PackageParametersContext();
            ContextExtensionPoint.executeInContext((Runnable)closure, (Context)context);
            this.parameters = context.parameters;
        }

        public void outputParameters(Runnable closure) {
            PackageOutputParametersContext context = new PackageOutputParametersContext();
            ContextExtensionPoint.executeInContext((Runnable)closure, (Context)context);
            this.outputParameters = context.outputParameters;
        }

        public class PackageOutputParametersContext
        implements Context {
            private static final String OPT_OUT_PARAM_NAME = "output parameter name";
            private final List<PackageOutputParameter> outputParameters = new ArrayList<PackageOutputParameter>();

            public void outputParameters(CharSequence name) {
                Preconditions.checkNotNull((Object)name, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_OUT_PARAM_NAME});
                FormValidation validation = TestBuilderDslExtension.this.validator.validatePackageOutputParameterName(name.toString());
                Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
                this.outputParameters.add(new PackageOutputParameter(name.toString()));
            }

            public void outputParameters(Runnable closure) {
                PackageOutputParameterContext context = new PackageOutputParameterContext();
                ContextExtensionPoint.executeInContext((Runnable)closure, (Context)context);
                this.outputParameters.add(new PackageOutputParameter(context.name));
            }

            public class PackageOutputParameterContext
            implements Context {
                private String name;

                public void name(CharSequence value) {
                    Preconditions.checkNotNull((Object)value, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{PackageOutputParametersContext.OPT_OUT_PARAM_NAME});
                    FormValidation validation = TestBuilderDslExtension.this.validator.validatePackageOutputParameterName(value.toString());
                    Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
                    this.name = value.toString();
                }
            }
        }

        public class PackageParametersContext
        implements Context {
            private static final String OPT_PARAM_NAME = "parameter name";
            private static final String OPT_PARAM_VALUE = "parameter value";
            private final List<PackageParameter> parameters = new ArrayList<PackageParameter>();

            public void parameter(CharSequence name, CharSequence value) {
                Preconditions.checkNotNull((Object)name, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_PARAM_NAME});
                Preconditions.checkNotNull((Object)value, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_PARAM_VALUE});
                FormValidation validation = TestBuilderDslExtension.this.validator.validateParameterName(name.toString());
                Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
                validation = TestBuilderDslExtension.this.validator.validateParameterValue(value.toString());
                Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
                this.parameters.add(new PackageParameter(name.toString(), value.toString()));
            }

            public void parameter(Runnable closure) {
                PackageParameterContext context = new PackageParameterContext();
                ContextExtensionPoint.executeInContext((Runnable)closure, (Context)context);
                this.parameters.add(new PackageParameter(context.name, context.value));
            }

            public class PackageParameterContext
            implements Context {
                private String name;
                private String value;

                public void name(CharSequence value) {
                    Preconditions.checkNotNull((Object)value, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{PackageParametersContext.OPT_PARAM_NAME});
                    FormValidation validation = TestBuilderDslExtension.this.validator.validateParameterName(value.toString());
                    Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
                    this.name = value.toString();
                }

                public void value(CharSequence value) {
                    Preconditions.checkNotNull((Object)value, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{PackageParametersContext.OPT_PARAM_VALUE});
                    FormValidation validation = TestBuilderDslExtension.this.validator.validateParameterValue(value.toString());
                    Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
                    this.value = value.toString();
                }
            }
        }
    }

    public class TestPackageContext
    extends AbstractTestBuilderDslExtension.AbstractTestContext {
        private PackageConfig packageConfig;

        public void packageConfig(Runnable closure) {
            PackageConfigContext context = new PackageConfigContext();
            ContextExtensionPoint.executeInContext((Runnable)closure, (Context)context);
            this.packageConfig = new PackageConfig(context.runTest, context.runTraceAnalysis, context.parameters, context.outputParameters);
        }
    }
}

