/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.extension.jobdsl;

import com.google.common.base.Preconditions;
import de.tracetronic.jenkins.plugins.ecutest.extension.jobdsl.AbstractDslExtension;
import de.tracetronic.jenkins.plugins.ecutest.tool.AbstractToolBuilder;
import de.tracetronic.jenkins.plugins.ecutest.util.validation.ToolValidator;
import hudson.EnvVars;
import hudson.util.FormValidation;
import javaposse.jobdsl.dsl.Context;

public abstract class AbstractToolBuilderDslExtension
extends AbstractDslExtension {
    protected final ToolValidator validator = new ToolValidator();

    protected void checkToolInstallation(String toolName, AbstractToolBuilder builder) {
        if (!toolName.isEmpty() && !toolName.contains("$")) {
            Preconditions.checkNotNull((Object)((Object)builder.getToolInstallation(new EnvVars())), (String)"'%s' is not in the list of configured ECU-TEST installations!", (Object[])new Object[]{toolName});
        }
    }

    public abstract class AbstractToolContext
    implements Context {
        protected String timeout = String.valueOf(this.getDefaultTimeout());

        protected abstract int getDefaultTimeout();

        public void timeout(CharSequence value) {
            Preconditions.checkNotNull((Object)value, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"timeout"});
            FormValidation validation = AbstractToolBuilderDslExtension.this.validator.validateTimeout(value.toString(), this.getDefaultTimeout());
            Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
            this.timeout = value.toString();
        }

        public void timeout(int value) {
            this.timeout(String.valueOf((Object)value));
        }
    }
}

