/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.extension.jobdsl;

import com.google.common.base.Preconditions;
import de.tracetronic.jenkins.plugins.ecutest.extension.jobdsl.AbstractDslExtension;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ExecutionConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.GlobalConstant;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportProjectConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.TMSConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.TestConfig;
import de.tracetronic.jenkins.plugins.ecutest.util.validation.TMSValidator;
import de.tracetronic.jenkins.plugins.ecutest.util.validation.TestValidator;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.List;
import javaposse.jobdsl.dsl.Context;
import javaposse.jobdsl.plugin.ContextExtensionPoint;

public abstract class AbstractTestBuilderDslExtension
extends AbstractDslExtension {
    protected static final String OPT_TEST_FILE = "testFile";
    protected final TestValidator validator = new TestValidator();
    protected final TMSValidator tmsValidator = new TMSValidator();

    public class AbstractExportContext
    implements Context {
        protected static final String OPT_EXPORT_PATH = "exportPath";
        protected static final String OPT_CREDENTIALS_ID = "credentialsId";
        protected final List<TMSConfig> exportConfigs = new ArrayList<TMSConfig>();
        protected String exportPath;

        public void exportPath(String value) {
            FormValidation validation = AbstractTestBuilderDslExtension.this.tmsValidator.validateExportPath(value);
            Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
            this.exportPath = value;
        }

        public class ExportTMSContext
        extends AbstractExportContext {
            protected String timeout;
            protected boolean createNewPath;

            public ExportTMSContext() {
                this.timeout = String.valueOf(TMSConfig.getDefaultTimeout());
            }

            public void timeout(String value) {
                FormValidation validation = AbstractTestBuilderDslExtension.this.tmsValidator.validateTimeout(value, TMSConfig.getDefaultTimeout());
                Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
                this.timeout = value;
            }

            public void timeout(int value) {
                this.timeout(String.valueOf((Object)value));
            }

            public void createNewPath(boolean value) {
                this.createNewPath = value;
            }
        }
    }

    public class AbstractImportContext
    implements Context {
        protected static final String OPT_IMPORT_PATH = "importPath";
        protected static final String OPT_CREDENTIALS_ID = "credentialsId";
        protected final List<TMSConfig> importConfigs = new ArrayList<TMSConfig>();
        protected String importPath;

        public void importPath(String value) {
            FormValidation validation = AbstractTestBuilderDslExtension.this.tmsValidator.validateImportPath(value);
            Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
            this.importPath = value;
        }

        public class ImportTMSContext
        extends AbstractImportContext {
            protected String timeout;
            protected boolean importMissingPackages;

            public ImportTMSContext() {
                this.timeout = String.valueOf(ImportProjectConfig.getDefaultTimeout());
            }

            public void timeout(String value) {
                FormValidation validation = AbstractTestBuilderDslExtension.this.tmsValidator.validateTimeout(value, ImportProjectConfig.getDefaultTimeout());
                Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
                this.timeout = value;
            }

            public void timeout(int value) {
                this.timeout(String.valueOf((Object)value));
            }

            public void importMissingPackages(boolean value) {
                this.importMissingPackages = value;
            }
        }
    }

    public abstract class AbstractTestContext
    implements Context {
        protected TestConfig testConfig;
        protected ExecutionConfig executionConfig;

        public void testConfig(Runnable closure) {
            TestConfigContext context = new TestConfigContext();
            ContextExtensionPoint.executeInContext((Runnable)closure, (Context)context);
            this.testConfig = new TestConfig(context.tbcFile, context.tcfFile, context.forceReload, context.loadOnly, context.keepConfig, context.constants);
        }

        public void executionConfig(Runnable closure) {
            ExecutionConfigContext context = new ExecutionConfigContext();
            ContextExtensionPoint.executeInContext((Runnable)closure, (Context)context);
            this.executionConfig = new ExecutionConfig(context.timeout, context.stopOnError, context.checkTestFile, context.recordWarnings);
        }

        public class ExecutionConfigContext
        implements Context {
            private String timeout;
            private boolean stopOnError = true;
            private boolean checkTestFile = true;
            private boolean recordWarnings = false;

            public void timeout(CharSequence value) {
                Preconditions.checkNotNull((Object)value, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{"timeout"});
                FormValidation validation = AbstractTestBuilderDslExtension.this.validator.validateTimeout(value.toString(), ExecutionConfig.getDefaultTimeout());
                Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
                this.timeout = value.toString();
            }

            public void timeout(int value) {
                this.timeout(String.valueOf((Object)value));
            }

            public void stopOnError(boolean value) {
                this.stopOnError = value;
            }

            public void checkTestFile(boolean value) {
                this.checkTestFile = value;
            }

            public void recordWarnings(boolean value) {
                this.recordWarnings = value;
            }
        }

        public class TestConfigContext
        implements Context {
            private static final String OPT_TBC_FILE = "tbcFile";
            private static final String OPT_TCF_FILE = "tcfFile";
            private static final String OPT_CONSTANT_NAME = "constant name";
            private static final String OPT_CONSTANT_VALUE = "constant value";
            private String tbcFile;
            private String tcfFile;
            private boolean forceReload;
            private boolean loadOnly;
            private boolean keepConfig;
            private List<GlobalConstant> constants;

            public void tbcFile(CharSequence value) {
                Preconditions.checkNotNull((Object)value, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_TBC_FILE});
                FormValidation validation = AbstractTestBuilderDslExtension.this.validator.validateTbcFile(value.toString());
                Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
                this.tbcFile = value.toString();
            }

            public void tcfFile(CharSequence value) {
                Preconditions.checkNotNull((Object)value, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{OPT_TCF_FILE});
                FormValidation validation = AbstractTestBuilderDslExtension.this.validator.validateTcfFile(value.toString());
                Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
                this.tcfFile = value.toString();
            }

            public void forceReload(boolean value) {
                this.forceReload = value;
            }

            public void loadOnly(boolean value) {
                this.loadOnly = value;
            }

            public void keepConfig(boolean value) {
                this.keepConfig = value;
            }

            public void constants(Runnable closure) {
                GlobalConstantsContext context = new GlobalConstantsContext();
                ContextExtensionPoint.executeInContext((Runnable)closure, (Context)context);
                this.constants = context.constants;
            }

            public class GlobalConstantsContext
            implements Context {
                private final List<GlobalConstant> constants = new ArrayList<GlobalConstant>();

                public void constant(CharSequence name, CharSequence value) {
                    Preconditions.checkNotNull((Object)value, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{TestConfigContext.OPT_CONSTANT_NAME});
                    Preconditions.checkNotNull((Object)value, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{TestConfigContext.OPT_CONSTANT_VALUE});
                    FormValidation validation = AbstractTestBuilderDslExtension.this.validator.validateGlobalConstantName(name.toString());
                    Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
                    validation = AbstractTestBuilderDslExtension.this.validator.validateGlobalConstantValue(value.toString());
                    Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
                    this.constants.add(new GlobalConstant(name.toString(), value.toString()));
                }

                public void constant(Runnable closure) {
                    GlobalConstantContext context = new GlobalConstantContext();
                    ContextExtensionPoint.executeInContext((Runnable)closure, (Context)context);
                    this.constants.add(new GlobalConstant(context.name, context.value));
                }

                public class GlobalConstantContext
                implements Context {
                    private String name;
                    private String value;

                    public void name(CharSequence value) {
                        Preconditions.checkNotNull((Object)value, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{TestConfigContext.OPT_CONSTANT_NAME});
                        FormValidation validation = AbstractTestBuilderDslExtension.this.validator.validateGlobalConstantName(value.toString());
                        Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
                        this.name = value.toString();
                    }

                    public void value(CharSequence value) {
                        Preconditions.checkNotNull((Object)value, (String)"Setting '%s' cannot be null!", (Object[])new Object[]{TestConfigContext.OPT_CONSTANT_VALUE});
                        FormValidation validation = AbstractTestBuilderDslExtension.this.validator.validateGlobalConstantValue(value.toString());
                        Preconditions.checkArgument((validation.kind != FormValidation.Kind.ERROR ? 1 : 0) != 0, (Object)validation.getMessage());
                        this.value = value.toString();
                    }
                }
            }
        }
    }
}

