/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.extension.agent;

import java.io.IOException;
import jenkins.slaves.restarter.SlaveRestarter;

public abstract class AbstractTaskAgentRestarter
extends SlaveRestarter {
    protected abstract String getTaskName();

    public boolean canWork() {
        try {
            int ret = this.queryTask();
            return ret == 0;
        }
        catch (IOException | InterruptedException exception) {
            return false;
        }
    }

    public void restart() throws Exception {
        int ret = this.execTask();
        throw new IOException("Failed restarting agent!\nTask completed with exit value: " + ret);
    }

    private int queryTask() throws InterruptedException, IOException {
        return this.runProcess("/query");
    }

    private int execTask() throws InterruptedException, IOException {
        return this.runProcess("/run");
    }

    private int runProcess(String option) throws IOException, InterruptedException {
        ProcessBuilder procBuilder = new ProcessBuilder("schtasks.exe", option, "/tn", this.getTaskName());
        Process proc = procBuilder.start();
        return proc.waitFor();
    }
}

