/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.env.view;

import de.tracetronic.jenkins.plugins.ecutest.ETPlugin;
import de.tracetronic.jenkins.plugins.ecutest.env.ToolEnvInvisibleAction;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.InvisibleAction;
import hudson.model.ParameterValue;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class ToolEnvActionView
extends InvisibleAction {
    private static final Logger LOGGER = Logger.getLogger(ToolEnvActionView.class.getName());
    private final Run<?, ?> build;
    private final transient TaskListener listener;

    public ToolEnvActionView(Run<?, ?> run, TaskListener listener) {
        this.build = run;
        this.listener = listener;
    }

    public Set<ParameterValue> getEnvVariables() {
        List toolEnvActions = this.build.getActions(ToolEnvInvisibleAction.class);
        int toolBuilderSize = toolEnvActions.size();
        LinkedHashSet<ParameterValue> toolEnvVars = new LinkedHashSet<ParameterValue>();
        try {
            EnvVars envVars = this.build.getEnvironment(this.listener);
            for (int i = 0; i < toolBuilderSize; ++i) {
                for (Map.Entry entry : envVars.entrySet()) {
                    if (!((String)entry.getKey()).startsWith("TT_TOOL") || !((String)entry.getKey()).endsWith(String.valueOf(i))) continue;
                    toolEnvVars.add((ParameterValue)new StringParameterValue((String)entry.getKey(), (String)entry.getValue()));
                }
            }
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Level.SEVERE, e.getMessage());
        }
        return toolEnvVars;
    }

    public List<ToolEnvInvisibleAction> getToolEnvActions() {
        return this.build.getActions(ToolEnvInvisibleAction.class);
    }

    public String getIconFile() {
        return ETPlugin.getIconFileName("icon-ecutest-tool-param", "icon-xlg");
    }

    @Extension
    public static final class RunListenerImpl
    extends RunListener<Run<?, ?>> {
        public void onCompleted(Run<?, ?> run, @Nonnull TaskListener listener) {
            if (run.getAction(ToolEnvInvisibleAction.class) != null) {
                run.addAction((Action)new ToolEnvActionView(run, listener));
            }
        }
    }
}

