/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.env.view;

import de.tracetronic.jenkins.plugins.ecutest.ETPlugin;
import de.tracetronic.jenkins.plugins.ecutest.env.TestEnvInvisibleAction;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.InvisibleAction;
import hudson.model.ParameterValue;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class TestEnvActionView
extends InvisibleAction {
    private static final Logger LOGGER = Logger.getLogger(TestEnvActionView.class.getName());
    private final Run<?, ?> build;
    private final transient TaskListener listener;

    public TestEnvActionView(Run<?, ?> run, TaskListener listener) {
        this.build = run;
        this.listener = listener;
    }

    public Set<ParameterValue> getEnvVariables() {
        List testEnvActions = this.build.getActions(TestEnvInvisibleAction.class);
        int testBuilderSize = testEnvActions.size();
        LinkedHashSet<ParameterValue> testEnvVars = new LinkedHashSet<ParameterValue>();
        try {
            EnvVars envVars = this.build.getEnvironment(this.listener);
            String buildWs = "";
            String buildWsPath = (String)envVars.get((Object)"WORKSPACE");
            if (buildWsPath != null) {
                buildWs = buildWsPath + File.separator;
            }
            for (int i = 0; i < testBuilderSize; ++i) {
                for (Map.Entry entry : envVars.entrySet()) {
                    if (!((String)entry.getKey()).startsWith("TT_TEST") || !((String)entry.getKey()).endsWith(String.valueOf(i))) continue;
                    String value = ((String)entry.getValue()).replace(buildWs, "");
                    testEnvVars.add((ParameterValue)new StringParameterValue((String)entry.getKey(), value));
                }
            }
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Level.SEVERE, e.getMessage());
        }
        return testEnvVars;
    }

    public List<TestEnvInvisibleAction> getTestEnvActions() {
        return this.build.getActions(TestEnvInvisibleAction.class);
    }

    public String getIconFile() {
        return ETPlugin.getIconFileName("icon-ecutest-test-param", "icon-xlg");
    }

    @Extension
    public static final class RunListenerImpl
    extends RunListener<Run<?, ?>> {
        public void onCompleted(Run<?, ?> run, @Nonnull TaskListener listener) {
            if (run.getAction(TestEnvInvisibleAction.class) != null) {
                run.addAction((Action)new TestEnvActionView(run, listener));
            }
        }
    }
}

