/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.env;

import de.tracetronic.jenkins.plugins.ecutest.env.ToolEnvInvisibleAction;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.EnvironmentContributor;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.List;
import javax.annotation.Nonnull;

@Extension
public class ToolEnvContributor
extends EnvironmentContributor {
    public static final String PREFIX = "TT_";
    public static final String TOOL_NAME = "TOOL_NAME_";
    public static final String TOOL_VERSION = "TOOL_VERSION_";
    public static final String TOOL_INSTALL = "TOOL_INSTALL_";
    public static final String TOOL_WORKSPACE = "TOOL_WORKSPACE_";
    public static final String TOOL_SETTINGS = "TOOL_SETTINGS_";
    public static final String TOOL_TIMEOUT = "TOOL_TIMEOUT_";
    public static final String TOOL_DEBUG_MODE = "TOOL_DEBUG_MODE_";
    public static final String TOOL_LAST_TBC = "TOOL_LAST_TBC_";
    public static final String TOOL_LAST_TCF = "TOOL_LAST_TCF_";

    public void buildEnvironmentFor(@Nonnull Run r, @Nonnull EnvVars envs, @Nonnull TaskListener listener) {
        List envActions = r.getActions(ToolEnvInvisibleAction.class);
        for (ToolEnvInvisibleAction action : envActions) {
            String id = String.valueOf(action.getToolId());
            envs.put("TT_TOOL_NAME_" + id, action.getToolName());
            envs.put("TT_TOOL_VERSION_" + id, action.getToolVersion());
            envs.put("TT_TOOL_INSTALL_" + id, action.getToolInstallation());
            envs.put("TT_TOOL_WORKSPACE_" + id, action.getToolWorkspace());
            envs.put("TT_TOOL_SETTINGS_" + id, action.getToolSettings());
            envs.put("TT_TOOL_TIMEOUT_" + id, String.valueOf(action.getTimeout()));
            envs.put("TT_TOOL_DEBUG_MODE_" + id, action.isDebugMode() ? "true" : "false");
            envs.put("TT_TOOL_LAST_TBC_" + id, action.getLastTbc());
            envs.put("TT_TOOL_LAST_TCF_" + id, action.getLastTcf());
        }
    }
}

