/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest.env;

import de.tracetronic.jenkins.plugins.ecutest.test.client.AbstractTestClient;
import de.tracetronic.jenkins.plugins.ecutest.test.client.PackageClient;
import hudson.model.InvisibleAction;
import java.util.Collections;
import java.util.Map;

public class TestEnvInvisibleAction
extends InvisibleAction {
    private final int testId;
    private final String testName;
    private final TestType testType;
    private final String testDescription;
    private final String testFile;
    private final String testTbc;
    private final String testTcf;
    private final String testReportDir;
    private final String testResult;
    private final int timeout;
    private final Map<String, String> outParams;

    public TestEnvInvisibleAction(int testId, AbstractTestClient testClient) {
        this.testId = testId;
        this.testName = testClient.getTestName();
        if (testClient instanceof PackageClient) {
            this.testType = TestType.PACKAGE;
            this.outParams = ((PackageClient)testClient).getOutputParameters();
        } else {
            this.testType = TestType.PROJECT;
            this.outParams = Collections.emptyMap();
        }
        this.testDescription = testClient.getTestDescription();
        this.testFile = testClient.getTestFile();
        this.testTbc = testClient.getTestConfig().getTbcFile();
        this.testTcf = testClient.getTestConfig().getTcfFile();
        this.testReportDir = testClient.getTestReportDir();
        this.testResult = testClient.getTestResult();
        this.timeout = testClient.getExecutionConfig().getParsedTimeout();
    }

    public int getTestId() {
        return this.testId;
    }

    public String getTestName() {
        return this.testName;
    }

    public TestType getTestType() {
        return this.testType;
    }

    public String getTestDescription() {
        return this.testDescription;
    }

    public String getTestFile() {
        return this.testFile;
    }

    public String getTestTbc() {
        return this.testTbc;
    }

    public String getTestTcf() {
        return this.testTcf;
    }

    public String getTestReportDir() {
        return this.testReportDir;
    }

    public String getTestResult() {
        return this.testResult;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public Map<String, String> getOutParams() {
        return this.outParams;
    }

    public static enum TestType {
        PACKAGE,
        PROJECT;

    }
}

