/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutest;

import de.tracetronic.jenkins.plugins.ecutest.report.atx.installation.ATXInstallation;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportPackageConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportPackageDirConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportProjectConfig;
import de.tracetronic.jenkins.plugins.ecutest.test.config.ImportProjectDirConfig;
import de.tracetronic.jenkins.plugins.ecutest.util.ToolVersion;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Items;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import jenkins.model.Jenkins;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkins.ui.icon.IconType;

public class ETPlugin {
    public static final ToolVersion ET_MIN_VERSION = new ToolVersion(7, 0, 0);
    public static final ToolVersion ET_MAX_VERSION = new ToolVersion(2020, 4, 0);
    public static final ToolVersion ATX_MIN_VERSION = new ToolVersion(1, 65, 0);
    public static final ToolVersion ATX_CONFIG_VERSION = new ToolVersion(1, 87, 0);

    @Initializer(before=InitMilestone.PLUGINS_STARTED)
    public static void addAliases() {
        String configPath = "de.tracetronic.jenkins.plugins.ecutest.test.config.";
        HashMap<String, Class> classMap = new HashMap<String, Class>();
        classMap.put("de.tracetronic.jenkins.plugins.ecutest.test.config.ImportPackageTMSConfig", ImportPackageConfig.class);
        classMap.put("de.tracetronic.jenkins.plugins.ecutest.test.config.ImportPackageTMSDirConfig", ImportPackageDirConfig.class);
        classMap.put("de.tracetronic.jenkins.plugins.ecutest.test.config.ImportProjectTMSConfig", ImportProjectConfig.class);
        classMap.put("de.tracetronic.jenkins.plugins.ecutest.test.config.ImportProjectTMSDirConfig", ImportProjectDirConfig.class);
        for (Map.Entry entry : classMap.entrySet()) {
            Items.XSTREAM2.addCompatibilityAlias((String)entry.getKey(), (Class)entry.getValue());
        }
    }

    public static String getIconFileName(String iconClassName, String iconStyle) {
        String iconClass = iconClassName + " " + iconStyle;
        try {
            Method getIconByClassSpec = IconSet.class.getMethod("getIconByClassSpec", Object.class);
            return ((Icon)getIconByClassSpec.invoke((Object)IconSet.icons, iconClass)).getUrl();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return IconSet.icons.getIconByClassSpec(iconClass).getUrl();
        }
    }

    @Initializer(after=InitMilestone.PLUGINS_STARTED)
    public void syncATXConfiguration() {
        ATXInstallation.DescriptorImpl descriptor = (ATXInstallation.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(ATXInstallation.DescriptorImpl.class);
        if (descriptor != null) {
            descriptor.syncWithDefaultConfig();
            descriptor.save();
        }
    }

    @Initializer(after=InitMilestone.JOB_LOADED)
    public void registerIcons() {
        for (String name : new String[]{"atx-report", "atx-trend", "ecu-test", "ecu-test-pkg", "ecu-test-prj", "report-generator", "test-guide", "test-param", "tool-param", "trf-report", "trace-check", "trace-report"}) {
            IconSet.icons.addIcon(new Icon(String.format("icon-ecutest-%s icon-sm", name), String.format("ecutest/icons/16x16/%s.png", name), "width: 16px; height: 16px;", IconType.PLUGIN));
            IconSet.icons.addIcon(new Icon(String.format("icon-ecutest-%s icon-md", name), String.format("ecutest/icons/24x24/%s.png", name), "width: 24px; height: 24px;", IconType.PLUGIN));
            IconSet.icons.addIcon(new Icon(String.format("icon-ecutest-%s icon-lg", name), String.format("ecutest/icons/32x32/%s.png", name), "width: 32px; height: 32px;", IconType.PLUGIN));
            IconSet.icons.addIcon(new Icon(String.format("icon-ecutest-%s icon-xlg", name), String.format("ecutest/icons/48x48/%s.png", name), "width: 48px; height: 48px;", IconType.PLUGIN));
        }
    }
}

