package de.tototec.cmdoption.handler;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;

/**
 * Apply an one-arg option to a field of type {@link String}.
 * 
 */
public class CharArrayHandler implements CmdOptionHandler {

	public boolean canHandle(final AccessibleObject element, final int argCount) {
		Class<?> type = null;
		if (element instanceof Field && argCount == 1) {
			type = ((Field) element).getType();
		} else if (element instanceof Method && argCount == 1) {
			final Method method = (Method) element;
			if (method.getParameterTypes().length == 1) {
				type = method.getParameterTypes()[0];
			}
		}
		if (type != null && type.isArray()) {
			final Class<?> componentType = type.getComponentType();
			return char.class.equals(componentType) || Character.class.equals(componentType);
		}
		return false;
	}

	public void applyParams(Object config, AccessibleObject element, String[] args, String optionName)
			throws CmdOptionHandlerException {
		// FIXME: UNFINISHED
		try {
			Field field = (Field) element;
			field.set(config, args[0]);

		} catch (Exception e) {
			// TODO better message
			throw new CmdOptionHandlerException("Could not apply parameters: " + Arrays.toString(args) + " to field "
					+ element, e);
		}

	}

}
