/*
 * Decompiled with CFR 0.152.
 */
package de.topobyte.osm4j.core.model.util;

import com.slimjars.dist.gnu.trove.list.TLongList;
import com.slimjars.dist.gnu.trove.list.array.TLongArrayList;
import de.topobyte.osm4j.core.model.iface.OsmEntity;
import de.topobyte.osm4j.core.model.iface.OsmRelation;
import de.topobyte.osm4j.core.model.iface.OsmRelationMember;
import de.topobyte.osm4j.core.model.iface.OsmTag;
import de.topobyte.osm4j.core.model.iface.OsmWay;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OsmModelUtil {
    public static Map<String, String> getTagsAsMap(OsmEntity entity) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < entity.getNumberOfTags(); ++i) {
            OsmTag tag = entity.getTag(i);
            map.put(tag.getKey(), tag.getValue());
        }
        return map;
    }

    public static List<? extends OsmTag> getTagsAsList(OsmEntity entity) {
        ArrayList<OsmTag> list = new ArrayList<OsmTag>();
        for (int i = 0; i < entity.getNumberOfTags(); ++i) {
            OsmTag tag = entity.getTag(i);
            list.add(tag);
        }
        return list;
    }

    public static TLongList nodesAsList(OsmWay way) {
        TLongArrayList ids = new TLongArrayList();
        for (int i = 0; i < way.getNumberOfNodes(); ++i) {
            ids.add(way.getNodeId(i));
        }
        return ids;
    }

    public static List<OsmRelationMember> membersAsList(OsmRelation relation) {
        ArrayList<OsmRelationMember> members = new ArrayList<OsmRelationMember>();
        for (int i = 0; i < relation.getNumberOfMembers(); ++i) {
            members.add(relation.getMember(i));
        }
        return members;
    }

    public static boolean isClosed(OsmWay way) {
        long idN;
        int n = way.getNumberOfNodes();
        if (n < 2) {
            return true;
        }
        long id0 = way.getNodeId(0);
        return id0 == (idN = way.getNodeId(n - 1));
    }
}

