/*
 * Decompiled with CFR 0.152.
 */
package de.thksystems.util.lang;

import org.apache.commons.lang3.ClassUtils;

public final class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static String getMessageList(Throwable t) {
        StringBuffer sb = new StringBuffer();
        int depth = 0;
        for (Throwable throwable = t; throwable != null; throwable = throwable.getCause()) {
            if (depth++ > 0) {
                sb.append("\n").append("--> ");
            }
            sb.append(ClassUtils.getAbbreviatedName(throwable.getClass(), (int)25)).append(": ").append(throwable.getMessage());
        }
        return sb.toString();
    }

    public static boolean isOfTypeOrHasCauseWithType(Throwable t, Class<? extends Throwable> expectedClass) {
        for (Throwable throwable = t; throwable != null; throwable = throwable.getCause()) {
            if (!expectedClass.isAssignableFrom(throwable.getClass())) continue;
            return true;
        }
        return false;
    }
}

