/*
 * Decompiled with CFR 0.152.
 */
package de.thksystems.util.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;

public final class ZipUtils {
    private ZipUtils() {
    }

    public static void zipDataToFile(File file, String zipEntryName, byte[] data) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        ZipOutputStream zos = new ZipOutputStream(fos);
        ZipEntry ze = new ZipEntry(zipEntryName);
        zos.putNextEntry(ze);
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        IOUtils.copy((InputStream)is, (OutputStream)zos);
        ((InputStream)is).close();
        zos.closeEntry();
        zos.close();
    }

    public static void zipStringToFile(File file, String zipEntryName, String stringToZip) throws IOException {
        ZipUtils.zipDataToFile(file, zipEntryName, stringToZip.getBytes());
    }
}

