/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shogun2.model.module;

import de.terrestris.shogun2.model.layout.Layout;
import de.terrestris.shogun2.model.module.Module;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table
public class CompositeModule
extends Module {
    private static final long serialVersionUID = 1L;
    @ManyToOne
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Layout layout;
    @ManyToMany
    @Cascade(value={CascadeType.SAVE_UPDATE})
    @JoinTable(name="MODULES_SUBMODULES", joinColumns={@JoinColumn(name="MODULE_ID")}, inverseJoinColumns={@JoinColumn(name="SUBMODULE_ID")})
    @OrderColumn(name="IDX")
    private List<Module> subModules = new ArrayList<Module>();

    public Layout getLayout() {
        return this.layout;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public void addModule(Module module) {
        this.subModules.add(module);
    }

    public void remove(Module module) {
        this.subModules.remove(module);
    }

    public List<Module> getSubModules() {
        return this.subModules;
    }

    public void setSubModules(List<Module> subModules) {
        this.subModules = subModules;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 19).appendSuper(super.hashCode()).append((Object)this.getLayout()).append(this.getSubModules()).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CompositeModule)) {
            return false;
        }
        CompositeModule other = (CompositeModule)obj;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.getLayout(), (Object)other.getLayout()).append(this.getSubModules(), other.getSubModules()).isEquals();
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.DEFAULT_STYLE);
    }
}

