/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shogun2.model.token;

import de.terrestris.shogun2.model.PersistentObject;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableInstant;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public abstract class Token
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    @Column(unique=true, updatable=false)
    private final String token = UUID.randomUUID().toString();
    @Column(updatable=false)
    @Type(type="org.jadira.usertype.dateandtime.joda.PersistentDateTime")
    private final ReadableDateTime expirationDate;

    protected Token(int expirationInMinutes) {
        this.expirationDate = ((DateTime)this.getCreated()).plusMinutes(expirationInMinutes);
    }

    public boolean expiresWithin(int minutes) {
        DateTime dateToCheck = DateTime.now().plusMinutes(minutes);
        boolean isExpired = dateToCheck.isAfter((ReadableInstant)this.expirationDate);
        return isExpired;
    }

    public String getToken() {
        return this.token;
    }

    public ReadableDateTime getExpirationDate() {
        return this.expirationDate;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 29).appendSuper(super.hashCode()).append((Object)this.getToken()).append((Object)this.getExpirationDate()).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Token)) {
            return false;
        }
        Token other = (Token)obj;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.getToken(), (Object)other.getToken()).append((Object)this.getExpirationDate(), (Object)other.getExpirationDate()).isEquals();
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.DEFAULT_STYLE);
    }
}

